/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization;

import eu.europeana.normalization.languages.LanguageMatcher;
import eu.europeana.normalization.normalizers.CleanIRIViolationsNormalizer;
import eu.europeana.normalization.normalizers.CleanMarkupTagsNormalizer;
import eu.europeana.normalization.normalizers.CleanSpaceCharactersNormalizer;
import eu.europeana.normalization.normalizers.DcLanguageNormalizer;
import eu.europeana.normalization.normalizers.NormalizeAction;
import eu.europeana.normalization.normalizers.RemoveDuplicateStatementNormalizer;
import eu.europeana.normalization.normalizers.XmlLangNormalizer;
import eu.europeana.normalization.settings.NormalizerSettings;
import eu.europeana.normalization.util.NormalizationConfigurationException;

public enum NormalizerStep {
    CLEAN_SPACE_CHARACTERS(settings -> new CleanSpaceCharactersNormalizer()),
    CLEAN_MARKUP_TAGS(settings -> new CleanMarkupTagsNormalizer(settings.getCleanMarkupTagsMode())),
    CLEAN_IRI_VIOLATIONS(settings -> new CleanIRIViolationsNormalizer()),
    REMOVE_DUPLICATE_STATEMENTS(settings -> new RemoveDuplicateStatementNormalizer()),
    NORMALIZE_DC_LANGUAGE_REFERENCES(settings -> {
        LanguageMatcher languageMatcher = new LanguageMatcher(settings.getMinLanguageLabelLength(), settings.getLanguageAmbiguityHandling(), settings.getTargetDcLanguageVocabularies());
        return new DcLanguageNormalizer(languageMatcher, settings.getMinimumConfidence());
    }),
    NORMALIZE_XML_LANG_REFERENCES(settings -> {
        LanguageMatcher languageMatcher = new LanguageMatcher(settings.getMinLanguageLabelLength(), settings.getLanguageAmbiguityHandling(), settings.getTargetXmlLangVocabularies());
        return new XmlLangNormalizer(languageMatcher, settings.getMinimumConfidence());
    });

    private final ActionCreator actionCreator;

    private NormalizerStep(ActionCreator actionCreator) {
        this.actionCreator = actionCreator;
    }

    NormalizeAction createAction(NormalizerSettings settings) throws NormalizationConfigurationException {
        return this.actionCreator.create(settings);
    }

    @FunctionalInterface
    private static interface ActionCreator {
        public NormalizeAction create(NormalizerSettings var1) throws NormalizationConfigurationException;
    }
}

