/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.util;

import eu.europeana.normalization.util.XmlException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtil.class);
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    private XmlUtil() {
    }

    public static String addPrefixToNodeName(String nodeName, String prefix) {
        return prefix == null ? nodeName : String.format("%s:%s", prefix, nodeName);
    }

    public static List<Element> elements(Element n) {
        return XmlUtil.getAsElementList(n.getChildNodes());
    }

    public static List<Element> elements(Element n, String elementName) {
        return XmlUtil.getAsElementList(n.getElementsByTagName(elementName));
    }

    public static List<Element> getAsElementList(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).filter(node -> node instanceof Element).map(node -> (Element)node).collect(Collectors.toList());
    }

    public static Element getElementByTagName(Element n, String elementName) {
        return (Element)n.getElementsByTagName(elementName).item(0);
    }

    public static Element getLastElementByTagName(Element n, String elementName) {
        NodeList elementsByTagName = n.getElementsByTagName(elementName);
        return elementsByTagName.getLength() == 0 ? null : (Element)elementsByTagName.item(elementsByTagName.getLength() - 1);
    }

    public static String getElementTextByTagName(Element n, String elementName) {
        Element subEl = XmlUtil.getElementByTagName(n, elementName);
        return subEl == null ? null : XmlUtil.getElementText(subEl);
    }

    public static String getElementText(Element element) {
        NodeList childNodes = element.getChildNodes();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 3) continue;
            result.append(node.getNodeValue());
        }
        return result.toString();
    }

    public static Document parseDom(Reader reader) throws XmlException {
        try {
            DocumentBuilder builder = FACTORY.newDocumentBuilder();
            return builder.parse(new InputSource(reader));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlException("Could not parse DOM for '" + reader.toString() + "'!", e);
        }
    }

    public static String writeDomToString(Document dom) throws XmlException {
        StringWriter ret = new StringWriter();
        XmlUtil.writeDom(dom, ret);
        return ret.toString();
    }

    public static byte[] writeDomToByteArray(Document dom) throws XmlException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        XmlUtil.writeDom(dom, writer);
        return outputStream.toByteArray();
    }

    private static void writeDom(Document dom, Writer writer) throws XmlException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(dom);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (RuntimeException | TransformerException e) {
            throw new XmlException("Could not write dom to string!", e);
        }
    }

    static {
        try {
            FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            FACTORY.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            FACTORY.setNamespaceAware(true);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Could not initialize static block XmlUtil", (Throwable)e);
        }
    }
}

