/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.util;

import com.ibm.icu.text.Transliterator;
import eu.europeana.normalization.util.LanguageTag;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class LanguageTagValueNormalizer {
    private static final char SUBTAG_SEPARATOR = '-';
    private static final Pattern CLEAN_SURPLUS_SPACES = Pattern.compile("\\s+");
    private static final Pattern CLEAN_PUNCTUATION_PATTERN = Pattern.compile("[\\p{Punct}\\u2013&&[^" + Pattern.quote(Character.toString('-')) + "]]+");
    private static final Transliterator TRANSLITERATOR = Transliterator.getInstance((String)"Greek-Latin/UNGEGN; Cyrillic-Latin; nfd; [:Nonspacing Mark:] remove; nfc; Lower");

    private LanguageTagValueNormalizer() {
    }

    public static List<LanguageTag> normalize(String input) {
        String normalizedInput = CLEAN_PUNCTUATION_PATTERN.matcher(input).replaceAll(" ");
        normalizedInput = CLEAN_SURPLUS_SPACES.matcher(normalizedInput).replaceAll(" ").trim();
        String[] words = normalizedInput.split("\\s+");
        return Stream.of(words).map(LanguageTagValueNormalizer::normalizeWord).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static LanguageTag normalizeWord(String word) {
        String trimmedWord = LanguageTagValueNormalizer.trimSeparators(word);
        if (trimmedWord.isEmpty()) {
            return null;
        }
        int subtagStart = trimmedWord.indexOf(45);
        String code = subtagStart < 0 ? trimmedWord : trimmedWord.substring(0, subtagStart);
        String subTag = subtagStart < 0 ? "" : trimmedWord.substring(subtagStart + 1);
        String normalizedWord = TRANSLITERATOR.transliterate(word);
        String normalizedCode = TRANSLITERATOR.transliterate(code);
        String normalizedSubtag = subTag.isEmpty() ? null : '-' + subTag;
        return new LanguageTag(normalizedWord, normalizedCode, normalizedSubtag);
    }

    private static String trimSeparators(String word) {
        int right;
        int left;
        for (left = 0; left < word.length() && word.charAt(left) == '-'; ++left) {
        }
        for (right = word.length(); left < right && word.charAt(right - 1) == '-'; --right) {
        }
        return word.substring(left, right);
    }
}

