/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.settings;

import eu.europeana.normalization.languages.LanguagesVocabulary;
import eu.europeana.normalization.settings.AmbiguityHandling;
import eu.europeana.normalization.settings.CleanMarkupTagsMode;
import eu.europeana.normalization.util.NormalizationConfigurationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class NormalizerSettings {
    protected static final float DEFAULT_MINIMUM_CONFIDENCE = 0.95f;
    protected static final List<LanguagesVocabulary> DEFAULT_DC_LANGUAGE_TARGET_VOCABULARIES = Collections.singletonList(LanguagesVocabulary.ISO_639_3);
    protected static final List<LanguagesVocabulary> DEFAULT_XML_LANG_TARGET_VOCABULARIES = Arrays.asList(LanguagesVocabulary.ISO_639_1, LanguagesVocabulary.ISO_639_3);
    protected static final int DEFAULT_MIN_LANGUAGE_LABEL_LENGTH = 4;
    protected static final AmbiguityHandling DEFAULT_LANGUAGE_AMBIGUITY_HANDLING = AmbiguityHandling.NO_MATCH;
    protected static final CleanMarkupTagsMode DEFAULT_CLEAN_MARKUP_TAGS_MODE = CleanMarkupTagsMode.HTML_ONLY;
    private float minimumConfidence = 0.95f;
    private List<LanguagesVocabulary> targetDcLanguageVocabularies = DEFAULT_DC_LANGUAGE_TARGET_VOCABULARIES;
    private List<LanguagesVocabulary> targetXmlLangVocabularies = DEFAULT_XML_LANG_TARGET_VOCABULARIES;
    private int minLanguageLabelLength = 4;
    private AmbiguityHandling languageAmbiguityHandling = DEFAULT_LANGUAGE_AMBIGUITY_HANDLING;
    private CleanMarkupTagsMode cleanMarkupTagsMode = DEFAULT_CLEAN_MARKUP_TAGS_MODE;

    public NormalizerSettings setMinimumConfidence(float minimumConfidence) throws NormalizationConfigurationException {
        if (minimumConfidence < 0.0f || minimumConfidence > 1.0f) {
            throw new NormalizationConfigurationException("Minimum confidence must be a number between 0 and 1 (inclusive).", null);
        }
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public float getMinimumConfidence() {
        return this.minimumConfidence;
    }

    public NormalizerSettings setTargetDcLanguageVocabularies(List<LanguagesVocabulary> targetDcLanguageVocabularies) throws NormalizationConfigurationException {
        if (targetDcLanguageVocabularies == null || targetDcLanguageVocabularies.isEmpty() || targetDcLanguageVocabularies.stream().anyMatch(Objects::isNull)) {
            throw new NormalizationConfigurationException("Provided vocabulary list is null, empty or has null entries", null);
        }
        this.targetDcLanguageVocabularies = new ArrayList<LanguagesVocabulary>(targetDcLanguageVocabularies);
        return this;
    }

    public List<LanguagesVocabulary> getTargetDcLanguageVocabularies() {
        return Collections.unmodifiableList(this.targetDcLanguageVocabularies);
    }

    public NormalizerSettings setTargetXmlLangVocabularies(List<LanguagesVocabulary> targetXmlLangVocabularies) throws NormalizationConfigurationException {
        if (targetXmlLangVocabularies == null || targetXmlLangVocabularies.isEmpty() || targetXmlLangVocabularies.stream().anyMatch(Objects::isNull)) {
            throw new NormalizationConfigurationException("Provided vocabulary list is null, empty or has null entries", null);
        }
        this.targetXmlLangVocabularies = new ArrayList<LanguagesVocabulary>(targetXmlLangVocabularies);
        return this;
    }

    public List<LanguagesVocabulary> getTargetXmlLangVocabularies() {
        return Collections.unmodifiableList(this.targetXmlLangVocabularies);
    }

    public NormalizerSettings setMinLanguageLabelLength(int minLanguageLabelLength) {
        this.minLanguageLabelLength = Math.max(minLanguageLabelLength, 0);
        return this;
    }

    public int getMinLanguageLabelLength() {
        return this.minLanguageLabelLength;
    }

    public NormalizerSettings setLanguageAmbiguityHandling(AmbiguityHandling languageAmbiguityHandling) throws NormalizationConfigurationException {
        if (languageAmbiguityHandling == null) {
            throw new NormalizationConfigurationException("Provided ambiguity strategy is null", null);
        }
        this.languageAmbiguityHandling = languageAmbiguityHandling;
        return this;
    }

    public AmbiguityHandling getLanguageAmbiguityHandling() {
        return this.languageAmbiguityHandling;
    }

    public NormalizerSettings setCleanMarkupTagsMode(CleanMarkupTagsMode cleanMarkupTagsMode) throws NormalizationConfigurationException {
        if (cleanMarkupTagsMode == null) {
            throw new NormalizationConfigurationException("Provided mode is null", null);
        }
        this.cleanMarkupTagsMode = cleanMarkupTagsMode;
        return this;
    }

    public CleanMarkupTagsMode getCleanMarkupTagsMode() {
        return this.cleanMarkupTagsMode;
    }
}

