/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.util;

import eu.europeana.normalization.util.Namespace;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class XpathQuery {
    public static final Namespace.Element RDF_TAG = Namespace.RDF.getElement("RDF");
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private final Map<String, String> namespaceMap;
    private final String expression;

    private XpathQuery(Map<String, String> namespaceMap, String expression) {
        this.namespaceMap = namespaceMap;
        this.expression = expression;
    }

    public static XpathQuery create(String expressionFormat, Namespace.Element ... elements) {
        String expression = String.format(expressionFormat, elements).trim();
        Map<String, String> namespaces = Arrays.stream(elements).map(Namespace.Element::getNamespace).distinct().collect(Collectors.toMap(Namespace::getTagPrefix, Namespace::getUri));
        return new XpathQuery(namespaces, expression);
    }

    public static XpathQuery combine(XpathQuery ... queries) {
        String expression = Arrays.stream(queries).map(query -> query.expression).collect(Collectors.joining(" | "));
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (XpathQuery query2 : queries) {
            for (Map.Entry<String, String> namespace : query2.namespaceMap.entrySet()) {
                XpathQuery.addNamespace(namespaces, namespace);
            }
        }
        return new XpathQuery(namespaces, expression);
    }

    private static void addNamespace(Map<String, String> namespaces, Map.Entry<String, String> namespace) {
        String currentUri = namespaces.get(namespace.getKey());
        if (currentUri != null && !currentUri.equals(namespace.getValue())) {
            throw new IllegalArgumentException("The same prefix " + namespace.getKey() + " is used for two different namespaces.", null);
        }
        namespaces.put(namespace.getKey(), namespace.getValue());
    }

    private XPathExpression toXPath() throws XPathExpressionException {
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(new SimpleNamespaceContext());
        return xpath.compile(this.expression);
    }

    public NodeList execute(Document dom) throws XPathExpressionException {
        return (NodeList)this.toXPath().evaluate(dom, XPathConstants.NODESET);
    }

    private class SimpleNamespaceContext
    implements NamespaceContext {
        private SimpleNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String result;
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            String resultFromMap = (String)XpathQuery.this.namespaceMap.get(prefix);
            if (resultFromMap != null) {
                return resultFromMap;
            }
            switch (prefix) {
                case "xml": {
                    result = "http://www.w3.org/XML/1998/namespace";
                    break;
                }
                case "xmlns": {
                    result = "http://www.w3.org/2000/xmlns/";
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

