/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.util;

import java.util.Formattable;
import java.util.Formatter;

public enum Namespace {
    XML("xml", "http://www.w3.org/XML/1998/namespace"),
    RDF("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"),
    EDM("edm", "http://www.europeana.eu/schemas/edm/"),
    ORE("ore", "http://www.openarchives.org/ore/terms/"),
    SKOS("skos", "http://www.w3.org/2004/02/skos/core#"),
    DC("dc", "http://purl.org/dc/elements/1.1/"),
    DCTERMS("dcterms", "http://purl.org/dc/terms/");

    private final String tagPrefix;
    private final String uri;

    private Namespace(String tagPrefix, String uri) {
        this.tagPrefix = tagPrefix;
        this.uri = uri;
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public String getUri() {
        return this.uri;
    }

    public Element getElement(String elementName) {
        return new Element(elementName, this);
    }

    public static final class Element
    implements Formattable {
        private final String elementName;
        private final Namespace namespace;

        private Element(String elementName, Namespace namespace) {
            this.elementName = elementName;
            this.namespace = namespace;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            formatter.format("%s:%s", this.namespace.tagPrefix, this.elementName);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            this.formatTo(new Formatter(result), 0, 0, 0);
            return result.toString();
        }
    }
}

