/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.normalizers;

import eu.europeana.normalization.languages.LanguageMatch;
import eu.europeana.normalization.languages.LanguageMatcher;
import eu.europeana.normalization.normalizers.NormalizedValueWithConfidence;
import eu.europeana.normalization.normalizers.RecordNormalizeAction;
import eu.europeana.normalization.normalizers.ValueNormalizeAction;
import eu.europeana.normalization.normalizers.ValueNormalizeActionWrapper;
import eu.europeana.normalization.settings.LanguageElement;
import eu.europeana.normalization.util.XpathQuery;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LanguageReferenceNormalizer
implements ValueNormalizeAction {
    protected static final float CONFIDENCE_SINGLE_CODE_EQUALS = 1.0f;
    protected static final float CONFIDENCE_SINGLE_CODE_KNOWN = 0.98f;
    protected static final float CONFIDENCE_LABELS_OR_CODES_MATCHES = 0.95f;
    protected static final float CONFIDENCE_LABELS_AND_CODES_MATCHES = 0.85f;
    private final float minimumConfidence;
    private final LanguageMatcher matcher;
    private final XpathQuery elementsToNormalize;

    public LanguageReferenceNormalizer(LanguageMatcher languageMatcher, float minimumConfidence, LanguageElement[] elementsToNormalize) {
        this.matcher = languageMatcher;
        this.elementsToNormalize = XpathQuery.combine((XpathQuery[])Stream.of(elementsToNormalize).map(LanguageElement::getElementQuery).toArray(XpathQuery[]::new));
        this.minimumConfidence = minimumConfidence;
    }

    @Override
    public List<NormalizedValueWithConfidence> normalizeValue(String label) {
        List<LanguageMatch> matches = this.matcher.match(label);
        Float confidence = this.determineConfidence(matches);
        if (confidence == null || confidence.floatValue() < this.minimumConfidence) {
            return Collections.emptyList();
        }
        return matches.stream().map(LanguageMatch::getMatch).distinct().map(language -> new NormalizedValueWithConfidence((String)language, confidence.floatValue())).collect(Collectors.toList());
    }

    Float determineConfidence(List<LanguageMatch> matches) {
        LanguageMatch match;
        if (matches.isEmpty()) {
            return null;
        }
        Set matchTypes = matches.stream().map(LanguageMatch::getType).distinct().collect(Collectors.toSet());
        boolean justCodeMatches = matchTypes.size() == 1 && matchTypes.contains((Object)LanguageMatch.Type.CODE_MATCH);
        boolean justLabelMatches = matchTypes.size() == 1 && matchTypes.contains((Object)LanguageMatch.Type.LABEL_MATCH);
        boolean justOneMatch = matches.size() == 1;
        boolean matchesFailed = matchTypes.contains((Object)LanguageMatch.Type.NO_MATCH);
        Float confidence = matchesFailed ? null : (justCodeMatches && justOneMatch ? ((match = matches.get(0)).getInput().equals(match.getMatch()) ? Float.valueOf(1.0f) : Float.valueOf(0.98f)) : (justCodeMatches || justLabelMatches ? Float.valueOf(0.95f) : Float.valueOf(0.85f)));
        return confidence;
    }

    @Override
    public RecordNormalizeAction getAsRecordNormalizer() {
        return new ValueNormalizeActionWrapper(this, this.elementsToNormalize);
    }
}

