/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.model;

import eu.europeana.normalization.model.NormalizationReport;
import eu.europeana.normalization.model.NormalizationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NormalizationBatchResult {
    private final NormalizationReport report;
    private final List<String> normalizedRecordsInEdmXml;
    private final int errorCount;

    public NormalizationBatchResult(List<NormalizationResult> results) {
        this.normalizedRecordsInEdmXml = new ArrayList<String>(results.size());
        this.report = new NormalizationReport();
        int errorCounter = 0;
        for (NormalizationResult result : results) {
            this.normalizedRecordsInEdmXml.add(result.getNormalizedRecordInEdmXml());
            if (result.getErrorMessage() != null) {
                ++errorCounter;
            }
            this.report.mergeWith(result.getReport());
        }
        this.errorCount = errorCounter;
    }

    public NormalizationReport getReport() {
        return this.report;
    }

    public List<String> getNormalizedRecordsInEdmXml() {
        return Collections.unmodifiableList(this.normalizedRecordsInEdmXml);
    }

    public int getErrorCount() {
        return this.errorCount;
    }
}

