/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.util;

import com.ibm.icu.text.Transliterator;
import java.util.regex.Pattern;

public final class StringNormalizer {
    private static final Pattern CLEAN_SURPLUS_SPACES = Pattern.compile("\\s+");
    private static final Pattern CLEAN_PUNCTUATION_PATTERN = Pattern.compile("[\\p{Punct}\\u2013]+");
    private static final Transliterator TRANSLITERATOR = Transliterator.getInstance((String)"Greek-Latin/UNGEGN; Cyrillic-Latin; nfd; [:Nonspacing Mark:] remove; nfc; Lower");

    private StringNormalizer() {
    }

    public static String normalize(String input) {
        String result = CLEAN_PUNCTUATION_PATTERN.matcher(input).replaceAll(" ");
        result = TRANSLITERATOR.transliterate(result);
        result = CLEAN_SURPLUS_SPACES.matcher(result).replaceAll(" ");
        return result.trim();
    }
}

