/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.normalizers;

import eu.europeana.normalization.normalizers.EdmValueNormalizer;
import eu.europeana.normalization.normalizers.NormalizedValueWithConfidence;
import eu.europeana.normalization.settings.CleanMarkupTagsMode;
import java.util.Collections;
import java.util.List;

public class CleanMarkupTagsNormalizer
extends EdmValueNormalizer {
    private final CleanMarkupTagsMode mode;

    public CleanMarkupTagsNormalizer(CleanMarkupTagsMode mode) {
        this.mode = mode;
    }

    @Override
    public List<NormalizedValueWithConfidence> normalizeValue(String htmlText) {
        String result = this.mode.getCleaner().apply(htmlText);
        if (result.length() == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new NormalizedValueWithConfidence(result, 1.0f));
    }
}

