/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.languages;

import eu.europeana.normalization.languages.Language;
import java.util.function.Function;

public enum LanguagesVocabulary {
    ISO_639_1(Language::getIso6391),
    ISO_639_2B(Language::getIso6392b),
    ISO_639_2T(Language::getIso6392t),
    ISO_639_3(Language::getIso6393),
    LANGUAGES_NAL(Language::getAuthorityCode);

    private final Function<Language, String> codeRetriever;

    private LanguagesVocabulary(Function<Language, String> codeRetriever) {
        this.codeRetriever = codeRetriever;
    }

    public String getCodeForLanguage(Language language) {
        return this.codeRetriever.apply(language);
    }
}

