/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.languages;

import eu.europeana.normalization.languages.LanguageLabel;
import eu.europeana.normalization.languages.LanguagesVocabulary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class Language {
    private String iso6391;
    private String iso6392b;
    private String iso6392t;
    private String iso6393;
    private String authorityCode;
    private final List<LanguageLabel> originalNames = new ArrayList<LanguageLabel>();
    private final List<LanguageLabel> alternativeNames = new ArrayList<LanguageLabel>();
    private final List<LanguageLabel> labels = new ArrayList<LanguageLabel>();

    public String getIso6391() {
        return this.iso6391;
    }

    void setIso6391(String iso6391) {
        this.iso6391 = iso6391;
    }

    public String getIso6392b() {
        return this.iso6392b;
    }

    void setIso6392b(String iso6392b) {
        this.iso6392b = iso6392b;
    }

    public String getIso6392t() {
        return this.iso6392t;
    }

    void setIso6392t(String iso6392t) {
        this.iso6392t = iso6392t;
    }

    public String getIso6393() {
        return this.iso6393;
    }

    void setIso6393(String iso6393) {
        this.iso6393 = iso6393;
    }

    public String getAuthorityCode() {
        return this.authorityCode;
    }

    public void setAuthorityCode(String authorityCode) {
        this.authorityCode = authorityCode;
    }

    void addOriginalNames(List<LanguageLabel> newOriginalNames) {
        this.originalNames.addAll(newOriginalNames);
    }

    void addAlternativeNames(List<LanguageLabel> newAlternativeNames) {
        this.alternativeNames.addAll(newAlternativeNames);
    }

    void addLabels(List<LanguageLabel> newLabels) {
        this.labels.addAll(newLabels);
    }

    public List<LanguageLabel> getOriginalNames() {
        return Collections.unmodifiableList(this.originalNames);
    }

    public List<LanguageLabel> getAlternativeNames() {
        return Collections.unmodifiableList(this.alternativeNames);
    }

    public List<LanguageLabel> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public Set<String> getAllLabels() {
        return Stream.of(this.originalNames, this.alternativeNames, this.labels).flatMap(Collection::stream).map(LanguageLabel::getLabel).collect(Collectors.toSet());
    }

    public Set<String> getAllLabelsAndCodes() {
        Set<String> result = this.getAllLabels();
        Set codes = Stream.of(this.iso6391, this.iso6392b, this.iso6392t, this.iso6393, this.authorityCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        result.addAll(codes);
        return result;
    }

    public String toString() {
        return "NalLanguage [iso6391=" + this.iso6391 + ", iso6392b=" + this.iso6392b + ", iso6392t=" + this.iso6392t + ", iso6393=" + this.iso6393 + ", authoritycode=" + this.authorityCode + ", originalNames=" + this.originalNames + ", alternativeNames=" + this.alternativeNames + ", labels=" + this.labels + "]";
    }

    public String getNormalizedLanguageId(LanguagesVocabulary vocabulary) {
        return vocabulary.getCodeForLanguage(this);
    }

    public String getPrefLabel(String resultLanguageCode) {
        LanguageLabel label = Stream.of(this.originalNames, this.alternativeNames, this.labels).flatMap(Collection::stream).filter(language -> StringUtils.equals((CharSequence)resultLanguageCode, (CharSequence)language.getLanguage())).findFirst().orElseGet(() -> this.originalNames.get(0));
        return label.getLabel();
    }
}

