/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization;

import eu.europeana.normalization.Normalizer;
import eu.europeana.normalization.model.NormalizationBatchResult;
import eu.europeana.normalization.model.NormalizationReport;
import eu.europeana.normalization.model.NormalizationResult;
import eu.europeana.normalization.normalizers.RecordNormalizeAction;
import eu.europeana.normalization.util.NormalizationException;
import eu.europeana.normalization.util.XmlException;
import eu.europeana.normalization.util.XmlUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class NormalizerImpl
implements Normalizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalizerImpl.class);
    private final RecordNormalizeAction recordNormalizer;

    NormalizerImpl(RecordNormalizeAction recordNormalizer) {
        this.recordNormalizer = recordNormalizer;
    }

    @Override
    public NormalizationBatchResult normalize(List<String> edmRecords) throws NormalizationException {
        if (edmRecords == null || edmRecords.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Input is null or contains null elements.");
        }
        ArrayList<NormalizationResult> result = new ArrayList<NormalizationResult>(edmRecords.size());
        for (String record : edmRecords) {
            result.add(this.normalize(record));
        }
        return new NormalizationBatchResult(result);
    }

    @Override
    public NormalizationResult normalize(String edmRecord) throws NormalizationException {
        if (edmRecord == null) {
            throw new IllegalArgumentException("Input is null.");
        }
        try {
            return this.normalizeInternal(edmRecord);
        }
        catch (XmlException e) {
            LOGGER.warn("Parsing of xml exception", (Throwable)e);
            return NormalizationResult.createInstanceForError("Error parsing XML: " + e.getMessage(), edmRecord);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected runtime exception", (Throwable)e);
            return NormalizationResult.createInstanceForError("Unexpected problem: " + e.getMessage(), edmRecord);
        }
    }

    private NormalizationResult normalizeInternal(String edmRecord) throws XmlException, NormalizationException {
        Document recordDom = XmlUtil.parseDom(new StringReader(edmRecord));
        NormalizationReport report = this.recordNormalizer.normalize(recordDom);
        String resultRecord = XmlUtil.writeDomToString(recordDom);
        return NormalizationResult.createInstanceForSuccess(resultRecord, report);
    }
}

