/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.schema.jibx.AudioChannelNumber;
import eu.europeana.metis.schema.jibx.BitRate;
import eu.europeana.metis.schema.jibx.CodecName;
import eu.europeana.metis.schema.jibx.ColorSpaceType;
import eu.europeana.metis.schema.jibx.DoubleType;
import eu.europeana.metis.schema.jibx.Duration;
import eu.europeana.metis.schema.jibx.HasColorSpace;
import eu.europeana.metis.schema.jibx.HasMimeType;
import eu.europeana.metis.schema.jibx.Height;
import eu.europeana.metis.schema.jibx.HexBinaryType;
import eu.europeana.metis.schema.jibx.IntegerType;
import eu.europeana.metis.schema.jibx.LongType;
import eu.europeana.metis.schema.jibx.NonNegativeIntegerType;
import eu.europeana.metis.schema.jibx.OrientationType;
import eu.europeana.metis.schema.jibx.SampleRate;
import eu.europeana.metis.schema.jibx.SampleSize;
import eu.europeana.metis.schema.jibx.SpatialResolution;
import eu.europeana.metis.schema.jibx.StringType;
import eu.europeana.metis.schema.jibx.Type1;
import eu.europeana.metis.schema.jibx.WebResourceType;
import eu.europeana.metis.schema.jibx.Width;
import eu.europeana.metis.schema.model.Orientation;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class WebResource {
    protected static final String FULL_TEXT_RESOURCE = "http://www.europeana.eu/schemas/edm/FullTextResource";
    private final WebResourceType resource;

    WebResource(WebResourceType resource) {
        this.resource = resource;
    }

    void setWidth(Integer width) {
        this.resource.setWidth(WebResource.intVal(Width::new, width));
    }

    void setHeight(Integer height) {
        this.resource.setHeight(WebResource.intVal(Height::new, height));
    }

    void setMimeType(String mimeType) {
        HasMimeType hasMimeType = new HasMimeType();
        hasMimeType.setHasMimeType(mimeType);
        this.resource.setHasMimeType(hasMimeType);
    }

    void setFileSize(Long fileSize) {
        if (fileSize == null) {
            this.resource.setFileByteSize(null);
        } else {
            this.resource.setFileByteSize(WebResource.longVal(fileSize));
        }
    }

    void setColorspace(ColorSpaceType colorSpace) {
        if (colorSpace == null) {
            this.resource.setHasColorSpace(null);
        } else {
            HasColorSpace hasColorSpace = new HasColorSpace();
            hasColorSpace.setHasColorSpace(colorSpace);
            this.resource.setHasColorSpace(hasColorSpace);
        }
    }

    void setOrientation(Orientation orientation) {
        this.resource.setOrientation(orientation == null ? null : WebResource.stringVal(OrientationType::new, orientation.getNameLowercase()));
    }

    void setDominantColors(List<String> dominantColors) {
        this.resource.setComponentColorList(dominantColors.stream().map(c -> {
            HexBinaryType hex = new HexBinaryType();
            hex.setString(c);
            hex.setDatatype("http://www.w3.org/2001/XMLSchema#hexBinary");
            return hex;
        }).collect(Collectors.toList()));
    }

    void setDuration(Double seconds) {
        if (seconds == null) {
            this.resource.setDuration(null);
        } else {
            int millisInSecond = 1000;
            Duration duration2 = new Duration();
            duration2.setDuration(Integer.toString((int)Math.round(seconds * 1000.0)));
            this.resource.setDuration(duration2);
        }
    }

    void setBitrate(Integer bitrate) {
        this.resource.setBitRate(WebResource.uintVal(BitRate::new, bitrate));
    }

    void setFrameRate(Double frameRate) {
        this.resource.setFrameRate(WebResource.doubleVal(frameRate));
    }

    void setCodecName(String codecName) {
        if (codecName == null) {
            this.resource.setCodecName(null);
        } else {
            CodecName codecName2 = new CodecName();
            codecName2.setCodecName(codecName);
            this.resource.setCodecName(codecName2);
        }
    }

    void setChannels(Integer channels) {
        this.resource.setAudioChannelNumber(WebResource.uintVal(AudioChannelNumber::new, channels));
    }

    void setSampleRate(Integer sampleRate) {
        this.resource.setSampleRate(WebResource.intVal(SampleRate::new, sampleRate));
    }

    void setSampleSize(Integer sampleSize) {
        this.resource.setSampleSize(WebResource.intVal(SampleSize::new, sampleSize));
    }

    void setContainsText(boolean containsText) {
        if (containsText) {
            Type1 type = new Type1();
            type.setResource(FULL_TEXT_RESOURCE);
            this.resource.setType(type);
        } else {
            this.resource.setType(null);
        }
    }

    void setResolution(Integer resolution) {
        this.resource.setSpatialResolution(WebResource.uintVal(SpatialResolution::new, resolution));
    }

    private static <T extends IntegerType> T intVal(Supplier<T> constructor, Integer value) {
        if (value == null) {
            return null;
        }
        IntegerType element = (IntegerType)constructor.get();
        element.setLong((long)value.intValue());
        element.setDatatype("http://www.w3.org/2001/XMLSchema#integer");
        return (T)element;
    }

    private static <T extends NonNegativeIntegerType> T uintVal(Supplier<T> constructor, Integer value) {
        if (value == null) {
            return null;
        }
        NonNegativeIntegerType element = (NonNegativeIntegerType)constructor.get();
        element.setInteger(BigInteger.valueOf(value.intValue()));
        element.setDatatype("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        return (T)element;
    }

    private static LongType longVal(long value) {
        LongType element = new LongType();
        element.setLong(value);
        element.setDatatype("http://www.w3.org/2001/XMLSchema#long");
        return element;
    }

    private static DoubleType doubleVal(Double value) {
        if (value == null) {
            return null;
        }
        DoubleType element = new DoubleType();
        element.setDouble(value);
        element.setDatatype("http://www.w3.org/2001/XMLSchema#double");
        return element;
    }

    private static <T extends StringType> T stringVal(Supplier<T> constructor, String value) {
        StringType element = (StringType)constructor.get();
        element.setString(value);
        element.setDatatype("http://www.w3.org/2001/XMLSchema#string");
        return (T)element;
    }
}

