/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.model.AbstractResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.ResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Thumbnail;
import eu.europeana.metis.mediaprocessing.model.WebResource;
import eu.europeana.metis.schema.jibx.ColorSpaceType;
import eu.europeana.metis.schema.model.Orientation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ImageResourceMetadata
extends AbstractResourceMetadata {
    private static final long serialVersionUID = -1818426883878915580L;
    private Integer width;
    private Integer height;
    private ColorSpaceType colorSpace;
    private List<String> dominantColors;

    public ImageResourceMetadata(String mimeType, String resourceUrl, Long contentSize) throws MediaExtractionException {
        this(mimeType, resourceUrl, contentSize, null, null, null, null, null);
    }

    public ImageResourceMetadata(String mimeType, String resourceUrl, Long contentSize, Integer width, Integer height, ColorSpaceType colorSpace, List<String> dominantColors, List<? extends Thumbnail> thumbnails) throws MediaExtractionException {
        super(mimeType, resourceUrl, contentSize, thumbnails);
        this.width = width;
        this.height = height;
        this.colorSpace = colorSpace;
        if (dominantColors != null) {
            Optional<String> badColor = dominantColors.stream().filter(color -> !color.matches("[0-9A-F]{6}")).findAny();
            if (badColor.isPresent()) {
                throw new MediaExtractionException("Unrecognized hex String: " + badColor.get());
            }
            this.dominantColors = dominantColors.stream().map(c -> "#" + c).collect(Collectors.toList());
        }
    }

    ImageResourceMetadata() {
    }

    @Override
    protected ResourceMetadata prepareForSerialization() {
        return new ResourceMetadata(this);
    }

    @Override
    protected void updateResource(WebResource resource) {
        super.updateResource(resource);
        resource.setWidth(this.width);
        resource.setHeight(this.height);
        Orientation orientation = this.width == null || this.height == null ? null : Orientation.calculate((int)this.width, (int)this.height);
        resource.setOrientation(orientation);
        resource.setColorspace(this.colorSpace);
        resource.setDominantColors(this.getDominantColors());
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public ColorSpaceType getColorSpace() {
        return this.colorSpace;
    }

    public List<String> getDominantColors() {
        return this.dominantColors == null ? Collections.emptyList() : Collections.unmodifiableList(this.dominantColors);
    }
}

