/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.http;

import eu.europeana.metis.mediaprocessing.http.AbstractHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;

public class MimeTypeDetectHttpClient
extends AbstractHttpClient<URL, String> {
    private final Tika tika = new Tika();

    public MimeTypeDetectHttpClient(int connectTimeout, int responseTimeout, int requestTimeout) {
        super(0, connectTimeout, responseTimeout, requestTimeout);
    }

    @Override
    protected String getResourceUrl(URL resourceEntry) {
        return resourceEntry.toString();
    }

    @Override
    protected String createResult(URL resourceEntry, URI actualUri, String mimeType, Long fileSize, AbstractHttpClient.ContentRetriever contentRetriever) throws IOException {
        try (InputStream inputStream = contentRetriever.getContent();){
            Metadata metadata = new Metadata();
            String resourceName = MimeTypeDetectHttpClient.getResourceNameFromUrl(actualUri);
            if (resourceName != null) {
                metadata.set("resourceName", resourceName);
            }
            if (mimeType != null) {
                int separatorIndex = mimeType.indexOf(59);
                String adjustedMimeType = separatorIndex < 0 ? mimeType : mimeType.substring(0, separatorIndex);
                metadata.set("Content-Type", adjustedMimeType);
            }
            if (fileSize != null) {
                metadata.set("Content-Length", fileSize.toString());
            }
            String string = this.tika.detect(inputStream, metadata);
            return string;
        }
    }

    private static String getResourceNameFromUrl(URI url) {
        String resourcePath = url.getPath().trim();
        if (resourcePath.isEmpty() || resourcePath.endsWith("/")) {
            return null;
        }
        int slashIndex = resourcePath.lastIndexOf(47);
        return slashIndex < 0 ? resourcePath : resourcePath.substring(slashIndex + 1);
    }
}

