/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.http;

import eu.europeana.metis.utils.SonarqubeNullcheckAvoidanceUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpClient<I, R>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpClient.class);
    private static final int HTTP_SUCCESS_MIN_INCLUSIVE = 200;
    private static final int HTTP_SUCCESS_MAX_EXCLUSIVE = 300;
    private static final long CLEAN_TASK_CHECK_INTERVAL_IN_SECONDS = 60L;
    private static final long MAX_TASK_IDLE_TIME_IN_SECONDS = 300L;
    private final PoolingHttpClientConnectionManager connectionManager;
    private final CloseableHttpClient client;
    private final ScheduledExecutorService connectionCleaningSchedule = Executors.newScheduledThreadPool(1);
    private final int requestTimeout;

    AbstractHttpClient(int maxRedirectCount, int connectTimeout, int responseTimeout, int requestTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setMaxRedirects(maxRedirectCount).setConnectTimeout(Timeout.ofMilliseconds((long)connectTimeout)).setResponseTimeout(Timeout.ofMilliseconds((long)responseTimeout)).build();
        this.requestTimeout = requestTimeout;
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setDefaultMaxPerRoute(1);
        this.client = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        this.connectionCleaningSchedule.scheduleWithFixedDelay(() -> this.cleanConnections(this.connectionManager), 60L, 60L, TimeUnit.SECONDS);
    }

    private void cleanConnections(PoolingHttpClientConnectionManager connectionManager) {
        try {
            connectionManager.closeExpired();
            connectionManager.closeIdle(TimeValue.ofSeconds((long)300L));
        }
        catch (RuntimeException e) {
            LOGGER.warn("Could not clean up expired and idle connections.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R download(I resourceEntry) throws IOException {
        final String resourceUlr = this.getResourceUrl(resourceEntry);
        final HttpGet httpGet = new HttpGet(resourceUlr);
        HttpClientContext context = HttpClientContext.create();
        TimerTask abortTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpGet httpGet2 = httpGet;
                synchronized (httpGet2) {
                    if (httpGet.cancel()) {
                        LOGGER.info("Aborting request due to time limit: {}.", (Object)resourceUlr);
                    }
                }
            }
        };
        Timer timer = new Timer(true);
        timer.schedule(abortTask, this.requestTimeout);
        ArrayList<Object> closeables = new ArrayList<Object>();
        try {
            URI actualUri;
            CloseableHttpResponse responseObject = this.client.execute((ClassicHttpRequest)httpGet, (HttpContext)context);
            closeables.add(responseObject);
            HttpEntity responseEntity = (HttpEntity)SonarqubeNullcheckAvoidanceUtils.performThrowingFunction((Object)responseObject, response -> {
                int status = response.getCode();
                if (!AbstractHttpClient.httpCallIsSuccessful(status)) {
                    throw new IOException("Download failed of resource " + resourceUlr + ". Status code " + status + " (message: " + response.getReasonPhrase() + ").");
                }
                return response.getEntity();
            });
            closeables.add(responseEntity);
            String mimeType = Optional.ofNullable(responseEntity).map(EntityDetails::getContentType).orElse(null);
            Long fileSize = Optional.ofNullable(responseEntity).map(EntityDetails::getContentLength).filter(size -> size >= 0L).orElse(null);
            RedirectLocations redirectUris = context.getRedirectLocations();
            URI uRI = actualUri = redirectUris == null || redirectUris.size() == 0 ? httpGet.getUri() : redirectUris.get(redirectUris.size() - 1);
            ContentRetriever contentRetriever = ContentRetriever.forNonCloseableContent(responseEntity == null ? InputStream::nullInputStream : () -> ((HttpEntity)responseEntity).getContent(), closeables::add);
            R r = this.createResult(resourceEntry, actualUri, mimeType, fileSize, contentRetriever);
            return r;
        }
        catch (URISyntaxException e) {
            throw new IOException("An unexpected exception occurred.", e);
        }
        catch (IOException | RuntimeException e) {
            if (httpGet.isCancelled()) {
                throw new IOException("The request was aborted: it exceeded the time limit.", e);
            }
            throw e;
        }
        finally {
            timer.cancel();
            abortTask.cancel();
            HttpGet httpGet2 = httpGet;
            synchronized (httpGet2) {
                if (httpGet.cancel()) {
                    LOGGER.debug("Aborting request after all processing is completed: {}.", (Object)resourceUlr);
                }
            }
            closeables.forEach((Consumer<Object>)((Consumer<Closeable>)closeable -> {
                try {
                    closeable.close();
                }
                catch (IOException | RuntimeException e) {
                    LOGGER.debug("Closing all resources after all processing is completed.", (Throwable)e);
                }
            }));
        }
    }

    private static boolean httpCallIsSuccessful(int status) {
        return status >= 200 && status < 300;
    }

    protected abstract String getResourceUrl(I var1);

    protected abstract R createResult(I var1, URI var2, String var3, Long var4, ContentRetriever var5) throws IOException;

    @Override
    public void close() throws IOException {
        this.connectionCleaningSchedule.shutdown();
        this.connectionManager.close();
        this.client.close();
    }

    private static class UnclosedInputStream
    extends InputStream {
        private final InputStream source;

        public UnclosedInputStream(InputStream source) {
            this.source = source;
        }

        @Override
        public int available() throws IOException {
            return this.source.available();
        }

        @Override
        public int read() throws IOException {
            return this.source.read();
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            return this.source.read(buffer, offset, length);
        }

        @Override
        public void close() {
        }
    }

    @FunctionalInterface
    protected static interface ContentRetriever {
        public InputStream getContent() throws IOException;

        public static ContentRetriever forNonCloseableContent(ContentRetriever contentRetriever, Consumer<InputStream> contentRetrievedListener) {
            return () -> {
                InputStream content = contentRetriever.getContent();
                contentRetrievedListener.accept(content);
                return new UnclosedInputStream(content);
            };
        }
    }
}

