/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.extraction.PdfToImageConverter;
import eu.europeana.metis.mediaprocessing.extraction.ThumbnailGenerator;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResultImpl;
import eu.europeana.metis.mediaprocessing.model.TextResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Thumbnail;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextProcessor
implements MediaProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextProcessor.class);
    private static final String PDF_MIME_TYPE = "application/pdf";
    private static final String PNG_MIME_TYPE = "image/png";
    protected static final int DISPLAY_DPI = 72;
    private final ThumbnailGenerator thumbnailGenerator;
    private final PdfToImageConverter pdfToImageConverter;

    TextProcessor(ThumbnailGenerator thumbnailGenerator, PdfToImageConverter pdfToImageConverter) {
        this.thumbnailGenerator = thumbnailGenerator;
        this.pdfToImageConverter = pdfToImageConverter;
    }

    @Override
    public boolean downloadResourceForFullProcessing() {
        return true;
    }

    @Override
    public ResourceExtractionResultImpl copyMetadata(Resource resource, String detectedMimeType) {
        return new ResourceExtractionResultImpl(new TextResourceMetadata(detectedMimeType, resource.getResourceUrl(), resource.getProvidedFileSize()));
    }

    boolean generateThumbnailForPdf(Resource resource, boolean mainThumbnailAvailable) {
        return !mainThumbnailAvailable || !resource.getUrlTypes().contains((Object)UrlType.IS_SHOWN_BY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceExtractionResultImpl extractMetadata(Resource resource, String detectedMimeType, boolean mainThumbnailAvailable) throws MediaExtractionException {
        Long contentSize;
        PdfCharacteristics characteristics;
        List thumbnails;
        try {
            if (!resource.hasContent()) {
                throw new MediaExtractionException("File does not exist or does not have content.");
            }
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine whether resource has content.", e);
        }
        if (PDF_MIME_TYPE.equals(detectedMimeType) && this.generateThumbnailForPdf(resource, mainThumbnailAvailable)) {
            Path pdfImage = this.pdfToImageConverter.convertToPdf(resource.getContentPath());
            try {
                thumbnails = (List)this.thumbnailGenerator.generateThumbnails(resource.getResourceUrl(), PNG_MIME_TYPE, pdfImage.toFile(), true).getRight();
            }
            finally {
                this.pdfToImageConverter.removePdfImageFileSilently(pdfImage);
            }
        } else {
            thumbnails = null;
        }
        if (PDF_MIME_TYPE.equals(detectedMimeType)) {
            characteristics = this.findPdfCharacteristics(resource.getContentFile());
        } else {
            boolean hasText = detectedMimeType.startsWith("text/") || "application/xhtml+xml".equals(detectedMimeType);
            characteristics = new PdfCharacteristics(hasText, null);
        }
        try {
            contentSize = this.nullIfNegative(resource.getContentSize());
        }
        catch (IOException | RuntimeException e) {
            TextProcessor.closeAllThumbnailsSilently(thumbnails);
            throw new MediaExtractionException("Could not determine the size of the resource " + resource.getResourceUrl(), e);
        }
        TextResourceMetadata metadata = new TextResourceMetadata(detectedMimeType, resource.getResourceUrl(), contentSize, characteristics.containsText(), this.nullIfNegative(characteristics.getResolution()), thumbnails);
        return new ResourceExtractionResultImpl(metadata, thumbnails);
    }

    private static void closeAllThumbnailsSilently(List<Thumbnail> thumbnails) {
        if (thumbnails != null) {
            for (Thumbnail thumbnail : thumbnails) {
                try {
                    thumbnail.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Could not close thumbnail: {}", (Object)thumbnail.getTargetName(), (Object)e);
                }
            }
        }
    }

    PdfCharacteristics findPdfCharacteristics(File content) throws MediaExtractionException {
        OpenPdfFile openPdf = this.openPdfFile(content);
        try {
            for (int i = 1; i <= openPdf.getNumberOfPages(); ++i) {
                openPdf.getPdfParser().processContent(i, (RenderListener)openPdf.getPdfListener());
                if (openPdf.getPdfListener().getDpi() != null && openPdf.getPdfListener().hasText()) break;
            }
            PdfCharacteristics pdfCharacteristics = new PdfCharacteristics(openPdf.getPdfListener().hasText(), openPdf.getPdfListener().getDpi());
            if (openPdf != null) {
                openPdf.close();
            }
            return pdfCharacteristics;
        }
        catch (Throwable throwable) {
            try {
                if (openPdf != null) {
                    try {
                        openPdf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MediaExtractionException("Problem while reading PDF file.", e);
            }
        }
    }

    OpenPdfFile openPdfFile(File content) throws IOException {
        return new OpenPdfFile(content);
    }

    static class PdfListener
    implements RenderListener {
        private Integer dpi;
        private boolean hasText;

        PdfListener() {
        }

        Integer getDpi() {
            return this.dpi;
        }

        boolean hasText() {
            return this.hasText;
        }

        public void beginTextBlock() {
        }

        public void endTextBlock() {
        }

        public void renderText(TextRenderInfo renderInfo) {
            this.hasText = this.hasText || !renderInfo.getText().isEmpty();
        }

        public void renderImage(ImageRenderInfo iri) {
            if (this.dpi != null) {
                return;
            }
            try {
                BufferedImage image = iri.getImage().getBufferedImage();
                if (image == null) {
                    return;
                }
                int widthInPixels = image.getWidth();
                int heightInPixels = image.getHeight();
                Matrix imageMatrix = iri.getImageCTM();
                double widthInInches = (double)imageMatrix.get(0) / 72.0;
                double heightInInches = (double)imageMatrix.get(4) / 72.0;
                long xDpi = Math.abs(Math.round((double)widthInPixels / widthInInches));
                long yDpi = Math.abs(Math.round((double)heightInPixels / heightInInches));
                this.dpi = (int)Math.min(xDpi, yDpi);
            }
            catch (IOException e) {
                LOGGER.info("Could not extract PDF image", (Throwable)e);
            }
        }
    }

    static class PdfCharacteristics {
        private final boolean containsText;
        private final Integer resolution;

        PdfCharacteristics(boolean containsText, Integer resolution) {
            this.containsText = containsText;
            this.resolution = resolution;
        }

        boolean containsText() {
            return this.containsText;
        }

        Integer getResolution() {
            return this.resolution;
        }
    }

    static class OpenPdfFile
    implements Closeable {
        private final PdfReader pdfReader;
        private PdfListener pdfListener;
        private PdfReaderContentParser pdfParser;

        OpenPdfFile(File content) throws IOException {
            this.pdfReader = new PdfReader(content.getAbsolutePath());
        }

        int getNumberOfPages() {
            return this.pdfReader.getNumberOfPages();
        }

        PdfListener getPdfListener() {
            this.pdfListener = this.pdfListener == null ? new PdfListener() : this.pdfListener;
            return this.pdfListener;
        }

        PdfReaderContentParser getPdfParser() {
            this.pdfParser = this.pdfParser == null ? new PdfReaderContentParser(this.pdfReader) : this.pdfParser;
            return this.pdfParser;
        }

        @Override
        public void close() {
            this.pdfReader.close();
        }
    }
}

