/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.schema.jibx.ColorSpaceType;
import java.util.Arrays;

public enum ColorSpaceMapping {
    CMY("CMY", ColorSpaceType.CMY),
    CMYK("CMYK", ColorSpaceType.CMYK),
    GRAYSCALE("Gray", ColorSpaceType.GRAYSCALE),
    HCL("HCL", ColorSpaceType.HCL),
    HC_LP("HCLp", ColorSpaceType.HC_LP),
    HSB("HSB", ColorSpaceType.HSB),
    HSI("HSI", ColorSpaceType.HSI),
    HSL("HSL", ColorSpaceType.HSL),
    HSV("HSV", ColorSpaceType.HSV),
    HWB("HWB", ColorSpaceType.HWB),
    LAB("Lab", ColorSpaceType.LAB),
    CIE_LAB("CIELab", ColorSpaceType.LAB),
    LCH("LCH", ColorSpaceType.LC_HAB),
    LC_HAB("LCHab", ColorSpaceType.LC_HAB),
    LC_HUV("LCHuv", ColorSpaceType.LC_HUV),
    LMS("LMS", ColorSpaceType.LMS),
    LOG("Log", ColorSpaceType.LOG),
    LUV("Luv", ColorSpaceType.LUV),
    OHTA("OHTA", ColorSpaceType.OHTA),
    REC601_LUMA("Rec601Luma", ColorSpaceType.REC601_LUMA),
    REC601_Y_CB_CR("Rec601YCbCr", ColorSpaceType.REC601_Y_CB_CR),
    REC709_LUMA("Rec709Luma", ColorSpaceType.REC709_LUMA),
    REC709_Y_CB_CR("Rec709YCbCr", ColorSpaceType.REC709_Y_CB_CR),
    RGB("RGB", ColorSpaceType.RGB),
    SC_RGB("scRGB", ColorSpaceType.SC_RGB),
    S_RGB("sRGB", ColorSpaceType.S_RGB),
    XYZ("XYZ", ColorSpaceType.XYZ),
    XY_Y("xyY", ColorSpaceType.XY_Y),
    Y_CB_CR("YCbCr", ColorSpaceType.Y_CB_CR),
    Y_DB_DR("YDbDr", ColorSpaceType.Y_DB_DR),
    YCC("YCC", ColorSpaceType.YCC),
    YIQ("YIQ", ColorSpaceType.YIQ),
    Y_PB_PR("YPbPr", ColorSpaceType.Y_PB_PR),
    YUV("YUV", ColorSpaceType.YUV),
    TRANSPARENT("Transparent", ColorSpaceType.OTHER),
    UNDEFINED("Undefined", ColorSpaceType.OTHER);

    private final String imageMagickName;
    private final ColorSpaceType mappedColorSpace;

    private ColorSpaceMapping(String imageMagickName, ColorSpaceType mappedColorSpace) {
        this.imageMagickName = imageMagickName;
        this.mappedColorSpace = mappedColorSpace;
    }

    public static ColorSpaceType getColorSpaceType(String imageMagickName) throws MediaExtractionException {
        if (imageMagickName == null) {
            throw new MediaExtractionException("Color space can not be null.");
        }
        return Arrays.stream(ColorSpaceMapping.values()).filter(mapping -> imageMagickName.equalsIgnoreCase(mapping.imageMagickName)).map(mapping -> mapping.mappedColorSpace).findAny().orElse(ColorSpaceType.OTHER);
    }
}

