/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.CommandExecutor;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.model.AbstractResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.AudioResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResultImpl;
import eu.europeana.metis.mediaprocessing.model.VideoResourceMetadata;
import eu.europeana.metis.schema.model.MediaType;
import io.lindstrom.mpd.MPDParser;
import io.lindstrom.mpd.data.AdaptationSet;
import io.lindstrom.mpd.data.FrameRate;
import io.lindstrom.mpd.data.MPD;
import io.lindstrom.mpd.data.Period;
import io.lindstrom.mpd.data.Representation;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AudioVideoProcessor
implements MediaProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AudioVideoProcessor.class);
    private static String globalFfprobeCommand;
    private final CommandExecutor commandExecutor;
    private final String ffprobeCommand;

    AudioVideoProcessor(CommandExecutor commandExecutor) throws MediaProcessorException {
        this(commandExecutor, AudioVideoProcessor.getGlobalFfprobeCommand(commandExecutor));
    }

    AudioVideoProcessor(CommandExecutor commandExecutor, String ffprobeCommand) {
        this.commandExecutor = commandExecutor;
        this.ffprobeCommand = ffprobeCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getGlobalFfprobeCommand(CommandExecutor commandExecutor) throws MediaProcessorException {
        Class<AudioVideoProcessor> clazz = AudioVideoProcessor.class;
        synchronized (AudioVideoProcessor.class) {
            if (globalFfprobeCommand == null) {
                globalFfprobeCommand = AudioVideoProcessor.discoverFfprobeCommand(commandExecutor);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return globalFfprobeCommand;
        }
    }

    static String discoverFfprobeCommand(CommandExecutor commandExecutor) throws MediaProcessorException {
        int indexVersion;
        int version;
        String command = "ffprobe";
        String output = commandExecutor.execute(Collections.singletonList("ffprobe"), true, message -> new MediaProcessorException("Error while looking for ffprobe tools: " + message));
        int n = version = Character.isDigit(output.charAt(indexVersion = output.lastIndexOf("version ") + "version ".length())) ? Integer.parseInt(String.valueOf(output.charAt(indexVersion))) : 0;
        if (version < 2 || version >= 5) {
            throw new MediaProcessorException("ffprobe version " + version + ".x not found");
        }
        return "ffprobe";
    }

    private static boolean resourceHasContent(Resource resource) throws MediaExtractionException {
        try {
            return resource.hasContent();
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine whether resource has content.", e);
        }
    }

    private static String validateUrl(String url) throws MediaExtractionException {
        try {
            return new URI(url).toURL().toString();
        }
        catch (RuntimeException | MalformedURLException | URISyntaxException e) {
            throw new MediaExtractionException("Could not validate URL: " + url, e);
        }
    }

    List<String> createAudioVideoAnalysisCommand(Resource resource) throws MediaExtractionException {
        String resourceLocation = AudioVideoProcessor.resourceHasContent(resource) ? resource.getContentPath().toString() : AudioVideoProcessor.validateUrl(resource.getResourceUrl());
        return Arrays.asList(this.ffprobeCommand, "-v", "quiet", "-print_format", "json", "-show_format", "-show_streams", "-hide_banner", resourceLocation);
    }

    @Override
    public boolean downloadResourceForFullProcessing() {
        return false;
    }

    @Override
    public ResourceExtractionResultImpl copyMetadata(Resource resource, String detectedMimeType) {
        AbstractResourceMetadata metadata;
        switch (MediaType.getMediaType((String)detectedMimeType)) {
            case AUDIO: {
                metadata = new AudioResourceMetadata(detectedMimeType, resource.getResourceUrl(), resource.getProvidedFileSize());
                break;
            }
            case VIDEO: {
                metadata = new VideoResourceMetadata(detectedMimeType, resource.getResourceUrl(), resource.getProvidedFileSize());
                break;
            }
            default: {
                metadata = null;
            }
        }
        return metadata == null ? null : new ResourceExtractionResultImpl(metadata);
    }

    @Override
    public ResourceExtractionResultImpl extractMetadata(Resource resource, String detectedMimeType, boolean mainThumbnailAvailable) throws MediaExtractionException {
        AbstractResourceMetadata metadata;
        if ("application/dash+xml".equals(detectedMimeType)) {
            metadata = this.parseMpdResource(resource, detectedMimeType);
        } else {
            Function<String, MediaExtractionException> exceptionProducer = message -> new MediaExtractionException("Problem while analyzing audio/video file: " + message);
            String response = this.commandExecutor.execute(this.createAudioVideoAnalysisCommand(resource), false, exceptionProducer);
            metadata = this.parseCommandResponse(resource, detectedMimeType, response);
        }
        return new ResourceExtractionResultImpl(metadata, null);
    }

    private Representation getRepresentationFromMpd(AdaptationSet videoAdaptationSet) throws MediaExtractionException {
        Representation videoRepresentation = (Representation)videoAdaptationSet.getRepresentations().get(0);
        if (videoAdaptationSet.getRepresentations().size() > 1 && (videoRepresentation = (Representation)videoAdaptationSet.getRepresentations().stream().filter(representation -> representation.getWidth() != null && representation.getHeight() != null).max(Comparator.comparing(representation -> representation.getWidth() * representation.getHeight())).orElse(null)) == null) {
            videoRepresentation = videoAdaptationSet.getRepresentations().stream().filter(representation -> representation.getMimeType() != null && representation.getMimeType().startsWith("video") || representation.getWidth() != null || representation.getHeight() != null).findFirst().orElseThrow(() -> new MediaExtractionException("Cannot find video representation element in mpd"));
        }
        return videoRepresentation;
    }

    AbstractResourceMetadata parseMpdResource(Resource resource, String detectedMimeType) throws MediaExtractionException {
        MPD mpd;
        MPDParser parser = new MPDParser();
        try (InputStream inputStream = resource.getActualLocation().toURL().openStream();){
            mpd = parser.parse(inputStream);
        }
        catch (IOException e) {
            throw new MediaExtractionException("Problem while analyzing audio/video file.", e);
        }
        Period period = (Period)mpd.getPeriods().stream().findFirst().orElseThrow(() -> new MediaExtractionException("Cannot find period element in mpd"));
        AdaptationSet videoAdaptationSet = period.getAdaptationSets().stream().filter(adaptationSet -> Stream.of(adaptationSet.getMimeType(), adaptationSet.getContentType()).filter(Objects::nonNull).findFirst().map(type -> type.startsWith("video")).orElse(Boolean.FALSE)).findFirst().orElseThrow(() -> new MediaExtractionException("Cannot find video adaptation set element in mpd"));
        Representation videoRepresentation = this.getRepresentationFromMpd(videoAdaptationSet);
        Duration durationValue = mpd.getMediaPresentationDuration();
        Long widthValue = videoRepresentation.getWidth() == null ? videoAdaptationSet.getWidth() : videoRepresentation.getWidth();
        Long heightValue = videoRepresentation.getHeight() == null ? videoAdaptationSet.getHeight() : videoRepresentation.getHeight();
        FrameRate frameRateValue = videoRepresentation.getFrameRate() == null ? videoAdaptationSet.getFrameRate() : videoRepresentation.getFrameRate();
        String codecNames = videoRepresentation.getCodecs() == null ? videoAdaptationSet.getCodecs() : videoRepresentation.getCodecs();
        Integer width = widthValue == null ? null : this.nullIfNegative(Math.toIntExact(widthValue));
        Integer height = heightValue == null ? null : this.nullIfNegative(Math.toIntExact(heightValue));
        Double duration = durationValue == null ? null : this.nullIfNegative(Double.valueOf(durationValue.getSeconds()));
        Double frameRate = frameRateValue == null ? null : this.nullIfNegative(frameRateValue.toDouble());
        Integer bitRate = this.nullIfNegative(Math.toIntExact(videoRepresentation.getBandwidth()));
        return new VideoResourceMetadata(detectedMimeType, resource.getResourceUrl(), null, duration, bitRate, width, height, codecNames, frameRate);
    }

    JSONObject readCommandResponseToJson(String response) {
        return new JSONObject(new JSONTokener(response));
    }

    AbstractResourceMetadata parseCommandResponse(Resource resource, String detectedMimeType, String response) throws MediaExtractionException {
        try {
            AbstractResourceMetadata metadata;
            JSONObject result = this.readCommandResponseToJson(response);
            if (!AudioVideoProcessor.resourceHasContent(resource) && result.length() == 0) {
                throw new MediaExtractionException("Analysis of this media file revealed no metadata. Probably it could not be downloaded.");
            }
            JSONObject format = result.getJSONObject("format");
            JSONObject videoStream = this.findStream(result, "video");
            JSONObject audioStream = this.findStream(result, "audio");
            boolean isAudio = audioStream != null;
            boolean isVideo = videoStream != null;
            Long fileSize = this.nullIfNegative(format.getLong("size"));
            if (isVideo) {
                JSONObject[] candidates = new JSONObject[]{videoStream, format};
                Double duration = this.findDouble("duration", candidates);
                Integer bitRate = this.findInt("bit_rate", candidates);
                Integer width = this.findInt("width", candidates);
                Integer height = this.findInt("height", candidates);
                String codecName = this.findString("codec_name", candidates);
                Double frameRate = this.calculateFrameRate(this.findString("avg_frame_rate", candidates));
                metadata = new VideoResourceMetadata(detectedMimeType, resource.getResourceUrl(), fileSize, duration, bitRate, width, height, codecName, frameRate);
            } else if (isAudio) {
                JSONObject[] candidates = new JSONObject[]{audioStream, format};
                Double duration = this.findDouble("duration", candidates);
                Integer bitRate = this.findInt("bit_rate", candidates);
                Integer channels = this.findInt("channels", candidates);
                Integer sampleRate = this.findInt("sample_rate", candidates);
                Integer sampleSize = this.findInt("bits_per_sample", candidates);
                String codecName = this.findString("codec_name", candidates);
                metadata = new AudioResourceMetadata(detectedMimeType, resource.getResourceUrl(), fileSize, duration, bitRate, channels, sampleRate, sampleSize, codecName);
            } else {
                throw new MediaExtractionException("No media streams");
            }
            return metadata;
        }
        catch (RuntimeException e) {
            LOGGER.info("Could not parse ffprobe response:\n" + StringUtils.join((Object[])new String[]{response, "\n"}), (Throwable)e);
            throw new MediaExtractionException("File seems to be corrupted", e);
        }
    }

    private Double calculateFrameRate(String frameRateString) {
        boolean zeroDenominator;
        String[] frameRateParts = frameRateString.split("/");
        double numerator = Double.parseDouble(frameRateParts[0]);
        double denominator = Double.parseDouble(frameRateParts[1]);
        boolean bl = zeroDenominator = denominator == 0.0;
        if (zeroDenominator) {
            boolean zeroNumerator = numerator == 0.0;
            return zeroNumerator ? Double.valueOf(0.0) : null;
        }
        return this.nullIfNegative(numerator / denominator);
    }

    Integer findInt(String key, JSONObject[] candidates) {
        int result = this.findValue(key, candidates, candidate -> candidate.optInt(key, Integer.MIN_VALUE), value -> Integer.MIN_VALUE != value);
        return this.nullIfNegative(result);
    }

    Double findDouble(String key, JSONObject[] candidates) {
        double result = this.findValue(key, candidates, candidate -> candidate.optDouble(key, Double.NaN), value -> !value.isNaN());
        return this.nullIfNegative(result);
    }

    String findString(String key, JSONObject[] candidates) {
        return this.findValue(key, candidates, candidate -> candidate.optString(key, ""), StringUtils::isNotBlank);
    }

    <T> T findValue(String key, JSONObject[] candidates, Function<JSONObject, T> valueGetter, Predicate<T> valueValidator) {
        return Stream.of(candidates).map(valueGetter).filter(valueValidator).findFirst().orElseThrow(() -> new JSONException("Could not find value for field: " + key));
    }

    JSONObject findStream(JSONObject data, String codecType) {
        for (Object streamObject : data.getJSONArray("streams")) {
            JSONObject stream = (JSONObject)streamObject;
            if (!codecType.equals(stream.getString("codec_type"))) continue;
            return stream;
        }
        return null;
    }
}

