/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing;

import eu.europeana.metis.mediaprocessing.AbstractThreadSafeWrapper;
import eu.europeana.metis.mediaprocessing.RdfBindingFactoryProvider;
import eu.europeana.metis.mediaprocessing.RdfSerializer;
import eu.europeana.metis.mediaprocessing.exception.RdfSerializationException;
import eu.europeana.metis.mediaprocessing.model.EnrichedRdf;
import eu.europeana.metis.schema.jibx.RDF;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

class RdfSerializerImpl
implements RdfSerializer {
    private final MarshallingContextWrapper marshallingContext = new MarshallingContextWrapper();

    RdfSerializerImpl() {
    }

    @Override
    public byte[] serialize(EnrichedRdf rdf) throws RdfSerializationException {
        byte[] byArray;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.serialize(rdf, outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RdfSerializationException("Problem with serializing RDF.", e);
            }
        }
        outputStream.close();
        return byArray;
    }

    @Override
    public void serialize(EnrichedRdf rdf, OutputStream outputStream) throws RdfSerializationException {
        this.marshallingContext.serializeFromRdf(rdf.finalizeRdf(), outputStream);
    }

    private static class MarshallingContextWrapper
    extends AbstractThreadSafeWrapper<IMarshallingContext, RdfSerializationException> {
        MarshallingContextWrapper() {
            super(() -> {
                try {
                    return RdfBindingFactoryProvider.getBindingFactory().createMarshallingContext();
                }
                catch (JiBXException e) {
                    throw new RdfSerializationException("Problem creating serializer.", e);
                }
            });
        }

        void serializeFromRdf(RDF rdf, OutputStream outputStream) throws RdfSerializationException {
            this.process(context -> {
                try {
                    context.marshalDocument((Object)rdf, "UTF-8", null, outputStream);
                    return null;
                }
                catch (JiBXException e) {
                    throw new RdfSerializationException("Problem with serializing RDF.", e);
                }
            });
        }
    }
}

