/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing;

import eu.europeana.metis.mediaprocessing.AbstractThreadSafeWrapper;
import eu.europeana.metis.mediaprocessing.RdfBindingFactoryProvider;
import eu.europeana.metis.mediaprocessing.RdfDeserializer;
import eu.europeana.metis.mediaprocessing.exception.RdfDeserializationException;
import eu.europeana.metis.mediaprocessing.model.EnrichedRdf;
import eu.europeana.metis.mediaprocessing.model.EnrichedRdfImpl;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.utils.RdfNamespaceContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class RdfDeserializerImpl
implements RdfDeserializer {
    private final UnmarshallingContextWrapper unmarshallingContext = new UnmarshallingContextWrapper();
    private final XPathExpressionWrapper getObjectExpression = new XPathExpressionWrapper(xPath -> xPath.compile("/rdf:RDF/ore:Aggregation/edm:object/@rdf:resource"));
    private final XPathExpressionWrapper getHasViewExpression = new XPathExpressionWrapper(xPath -> xPath.compile("/rdf:RDF/ore:Aggregation/edm:hasView/@rdf:resource"));
    private final XPathExpressionWrapper getIsShownAtExpression = new XPathExpressionWrapper(xPath -> xPath.compile("/rdf:RDF/ore:Aggregation/edm:isShownAt/@rdf:resource"));
    private final XPathExpressionWrapper getIsShownByExpression = new XPathExpressionWrapper(xPath -> xPath.compile("/rdf:RDF/ore:Aggregation/edm:isShownBy/@rdf:resource"));

    RdfDeserializerImpl() {
    }

    @Override
    public RdfResourceEntry getMainThumbnailResourceForMediaExtraction(byte[] input) throws RdfDeserializationException {
        return RdfDeserializerImpl.performDeserialization(input, this::getMainThumbnailResourceForMediaExtraction);
    }

    @Override
    public RdfResourceEntry getMainThumbnailResourceForMediaExtraction(InputStream inputStream) throws RdfDeserializationException {
        return this.getMainThumbnailResourceForMediaExtraction(this.deserializeToDocument(inputStream)).orElse(null);
    }

    private Optional<RdfResourceEntry> getMainThumbnailResourceForMediaExtraction(Document record) throws RdfDeserializationException {
        Map<String, Set<UrlType>> resourceEntries = this.getResourceEntries(record, Collections.singleton(UrlType.URL_TYPE_FOR_MAIN_THUMBNAIL_RESOURCE));
        if (resourceEntries.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(RdfDeserializerImpl.convertToResourceEntries(resourceEntries).get(0));
    }

    @Override
    public List<RdfResourceEntry> getRemainingResourcesForMediaExtraction(byte[] input) throws RdfDeserializationException {
        return RdfDeserializerImpl.performDeserialization(input, this::getRemainingResourcesForMediaExtraction);
    }

    @Override
    public List<RdfResourceEntry> getRemainingResourcesForMediaExtraction(InputStream inputStream) throws RdfDeserializationException {
        Document record = this.deserializeToDocument(inputStream);
        Map<String, Set<UrlType>> allResources = this.getResourceEntries(record, UrlType.URL_TYPES_FOR_MEDIA_EXTRACTION);
        this.getMainThumbnailResourceForMediaExtraction(record).map(RdfResourceEntry::getResourceUrl).ifPresent(allResources::remove);
        return RdfDeserializerImpl.convertToResourceEntries(allResources);
    }

    @Override
    public List<RdfResourceEntry> getResourceEntriesForLinkChecking(byte[] input) throws RdfDeserializationException {
        return RdfDeserializerImpl.performDeserialization(input, this::getResourceEntriesForLinkChecking);
    }

    @Override
    public List<RdfResourceEntry> getResourceEntriesForLinkChecking(InputStream inputStream) throws RdfDeserializationException {
        return RdfDeserializerImpl.convertToResourceEntries(this.getResourceEntries(this.deserializeToDocument(inputStream), UrlType.URL_TYPES_FOR_LINK_CHECKING));
    }

    private static List<RdfResourceEntry> convertToResourceEntries(Map<String, Set<UrlType>> urlWithTypes) {
        return urlWithTypes.entrySet().stream().map(RdfDeserializerImpl::convertToResourceEntry).collect(Collectors.toList());
    }

    private static RdfResourceEntry convertToResourceEntry(Map.Entry<String, Set<UrlType>> entry) {
        return new RdfResourceEntry(entry.getKey(), (Collection<UrlType>)entry.getValue());
    }

    Map<String, Set<UrlType>> getResourceEntries(Document document, Set<UrlType> allowedUrlTypes) throws RdfDeserializationException {
        HashMap<String, Set<UrlType>> urls = new HashMap<String, Set<UrlType>>();
        for (UrlType type : allowedUrlTypes) {
            Set<String> urlsForType = this.getUrls(document, type);
            for (String url : urlsForType) {
                urls.computeIfAbsent(url, k -> new HashSet()).add(type);
            }
        }
        return urls;
    }

    private Set<String> getUrls(Document document, UrlType type) throws RdfDeserializationException {
        XPathExpressionWrapper expression;
        switch (type) {
            case OBJECT: {
                expression = this.getObjectExpression;
                break;
            }
            case HAS_VIEW: {
                expression = this.getHasViewExpression;
                break;
            }
            case IS_SHOWN_AT: {
                expression = this.getIsShownAtExpression;
                break;
            }
            case IS_SHOWN_BY: {
                expression = this.getIsShownByExpression;
                break;
            }
            default: {
                return Collections.emptySet();
            }
        }
        NodeList nodes = expression.evaluate(document);
        return IntStream.range(0, nodes.getLength()).mapToObj(nodes::item).map(Node::getNodeValue).collect(Collectors.toSet());
    }

    private Document deserializeToDocument(InputStream inputStream) throws RdfDeserializationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RdfDeserializationException("Problem with deserializing record to XML document.", e);
        }
    }

    @Override
    public EnrichedRdf getRdfForResourceEnriching(byte[] input) throws RdfDeserializationException {
        return RdfDeserializerImpl.performDeserialization(input, this::getRdfForResourceEnriching);
    }

    @Override
    public EnrichedRdf getRdfForResourceEnriching(InputStream inputStream) throws RdfDeserializationException {
        return new EnrichedRdfImpl(this.unmarshallingContext.deserializeToRdf(inputStream));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <R> R performDeserialization(byte[] input, DeserializationOperation<R> operation) throws RdfDeserializationException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(input);){
            R r = operation.performDeserialization(inputStream);
            return r;
        }
        catch (IOException e) {
            throw new RdfDeserializationException("Problem with reading byte array - Shouldn't happen.", e);
        }
    }

    @FunctionalInterface
    private static interface DeserializationOperation<R> {
        public R performDeserialization(InputStream var1) throws RdfDeserializationException;
    }

    private static class UnmarshallingContextWrapper
    extends AbstractThreadSafeWrapper<IUnmarshallingContext, RdfDeserializationException> {
        public UnmarshallingContextWrapper() {
            super(() -> {
                try {
                    return RdfBindingFactoryProvider.getBindingFactory().createUnmarshallingContext();
                }
                catch (JiBXException e) {
                    throw new RdfDeserializationException("Problem creating deserializer.", e);
                }
            });
        }

        public RDF deserializeToRdf(InputStream inputStream) throws RdfDeserializationException {
            return this.process(context -> {
                try {
                    return (RDF)context.unmarshalDocument(inputStream, "UTF-8");
                }
                catch (JiBXException e) {
                    throw new RdfDeserializationException("Problem with deserializing record to RDF.", e);
                }
            });
        }
    }

    private static class XPathExpressionWrapper
    extends AbstractThreadSafeWrapper<XPathExpression, RdfDeserializationException> {
        XPathExpressionWrapper(AbstractThreadSafeWrapper.ThrowingFunction<XPath, XPathExpression, XPathExpressionException> expressionCreator) {
            super(() -> {
                Class<XPathFactory> clazz = XPathFactory.class;
                synchronized (XPathFactory.class) {
                    XPathFactory factory = XPathFactory.newInstance();
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    XPath xPath = factory.newXPath();
                    xPath.setNamespaceContext((NamespaceContext)new RdfNamespaceContext());
                    try {
                        return (XPathExpression)expressionCreator.apply(xPath);
                    }
                    catch (XPathExpressionException e) {
                        throw new RdfDeserializationException("Could not initialize xpath expression.", e);
                    }
                }
            });
        }

        NodeList evaluate(Document document) throws RdfDeserializationException {
            return this.process(compiledExpression -> {
                try {
                    return (NodeList)compiledExpression.evaluate(document, XPathConstants.NODESET);
                }
                catch (XPathExpressionException e) {
                    throw new RdfDeserializationException("Problem with deserializing RDF.", e);
                }
            });
        }
    }
}

