/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing;

import eu.europeana.metis.mediaprocessing.LinkChecker;
import eu.europeana.metis.mediaprocessing.MediaExtractor;
import eu.europeana.metis.mediaprocessing.MediaProcessorFactory;
import eu.europeana.metis.mediaprocessing.PoolableProcessor;
import eu.europeana.metis.mediaprocessing.exception.LinkCheckingException;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.model.MediaExtractorInput;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResult;
import java.io.Closeable;
import java.time.Duration;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;

public abstract class AbstractMediaProcessorPool<I, O, E extends Exception, T extends PoolableProcessor<I, O, E>>
implements Closeable {
    private static final int MAX_IDLE_TIME_FOR_PROCESSOR_IN_SECONDS = 300;
    private static final int IDLE_TIME_CHECK_INTERVAL_IN_SECONDS = 60;
    private final GenericObjectPool<T> pool;

    private AbstractMediaProcessorPool(MediaProcessorFactory processorFactory) {
        this.pool = new GenericObjectPool(new PooledProcessorFactory<PoolableProcessor>(processorFactory, this::createProcessor));
        this.pool.setMaxIdle(-1);
        this.pool.setMinIdle(-1);
        this.pool.setMaxTotal(-1);
        this.pool.setSoftMinEvictableIdleTimeMillis(-1L);
        this.pool.setMinEvictableIdleTimeMillis(AbstractMediaProcessorPool.convertSecsToMillis(300L));
        this.pool.setTimeBetweenEvictionRunsMillis(AbstractMediaProcessorPool.convertSecsToMillis(60L));
    }

    private static long convertSecsToMillis(long seconds) {
        return Duration.ofSeconds(seconds).toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final O processTask(I input) throws MediaProcessorException, E {
        PoolableProcessor processor;
        try {
            processor = (PoolableProcessor)this.pool.borrowObject();
        }
        catch (Exception e) {
            throw new MediaProcessorException("Error while obtaining processor from the pool.", e);
        }
        try {
            Object o = processor.processTask(input);
            return o;
        }
        finally {
            this.pool.returnObject((Object)processor);
        }
    }

    abstract T createProcessor(MediaProcessorFactory var1) throws MediaProcessorException;

    @Override
    public void close() {
        this.pool.close();
    }

    public static class LinkCheckerPool
    extends AbstractMediaProcessorPool<String, Void, LinkCheckingException, LinkChecker> {
        public LinkCheckerPool(MediaProcessorFactory processorFactory) {
            super(processorFactory);
        }

        @Override
        LinkChecker createProcessor(MediaProcessorFactory processorFactory) throws MediaProcessorException {
            return processorFactory.createLinkChecker();
        }
    }

    public static class MediaExtractorPool
    extends AbstractMediaProcessorPool<MediaExtractorInput, ResourceExtractionResult, MediaExtractionException, MediaExtractor> {
        public MediaExtractorPool(MediaProcessorFactory processorFactory) {
            super(processorFactory);
        }

        @Override
        MediaExtractor createProcessor(MediaProcessorFactory processorFactory) throws MediaProcessorException {
            return processorFactory.createMediaExtractor();
        }

        public ResourceExtractionResult processTask(RdfResourceEntry resourceEntry, boolean mainThumbnailAvailable) throws MediaProcessorException, MediaExtractionException {
            return (ResourceExtractionResult)this.processTask(new MediaExtractorInput(resourceEntry, mainThumbnailAvailable));
        }

        @Override
        @Deprecated(forRemoval=true)
        public ResourceExtractionResult processTask(RdfResourceEntry resourceEntry) throws MediaProcessorException, MediaExtractionException {
            return (ResourceExtractionResult)this.processTask(new MediaExtractorInput(resourceEntry, false));
        }
    }

    private static interface ProcessorCreator<T> {
        public T create(MediaProcessorFactory var1) throws MediaProcessorException;
    }

    private static class PooledProcessorFactory<T extends Closeable>
    extends BasePooledObjectFactory<T> {
        private final MediaProcessorFactory processorFactory;
        private final ProcessorCreator<T> processorCreator;

        PooledProcessorFactory(MediaProcessorFactory processorFactory, ProcessorCreator<T> processorCreator) {
            this.processorFactory = processorFactory;
            this.processorCreator = processorCreator;
        }

        public T create() throws MediaProcessorException {
            return (T)((Closeable)this.processorCreator.create(this.processorFactory));
        }

        public PooledObject<T> wrap(T processor) {
            return new DefaultPooledObject(processor);
        }

        public void destroyObject(PooledObject<T> pooledProcessor) throws Exception {
            ((Closeable)pooledProcessor.getObject()).close();
            super.destroyObject(pooledProcessor);
        }
    }
}

