/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.mediaprocessing.model.ResourceRelatedFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

abstract class AbstractTemporaryFile
implements ResourceRelatedFile {
    private final String resourceUrl;
    private Path contentPath;
    private final ContentFileCreator contentFileCreator;

    AbstractTemporaryFile(String resourceUrl, String prefix, String suffix) {
        this.resourceUrl = resourceUrl;
        this.contentFileCreator = () -> Files.createTempFile(prefix, suffix, new FileAttribute[0]);
    }

    @Override
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    Path getContentPath() {
        return this.contentPath;
    }

    @Override
    public void markAsWithContent(InputStream newContent) throws IOException {
        if (this.contentPath == null) {
            this.contentPath = this.contentFileCreator.createFile();
        }
        Files.copy(newContent, this.contentPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private Long computeContentSizeInternal() throws IOException {
        if (this.contentPath != null && !this.contentPath.toFile().exists()) {
            this.contentPath = null;
        }
        return this.contentPath == null ? null : Long.valueOf(Files.size(this.contentPath));
    }

    @Override
    public boolean hasContent() throws IOException {
        Long result = this.computeContentSizeInternal();
        return result != null && result > 0L;
    }

    @Override
    public InputStream getContentStream() throws IOException {
        if (!this.hasContent()) {
            throw new IOException("Cannot get the file content: file does not exist or is empty.");
        }
        return Files.newInputStream(this.contentPath, new OpenOption[0]);
    }

    @Override
    public Long getContentSize() throws IOException {
        Long result = this.computeContentSizeInternal();
        if (result == null) {
            throw new IOException("Cannot get the file size: file does not exist.");
        }
        return result;
    }

    @Override
    public void markAsNoContent() throws IOException {
        try {
            if (this.contentPath != null && this.contentPath.toFile().exists()) {
                Files.delete(this.contentPath);
            }
        }
        finally {
            this.contentPath = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.markAsNoContent();
    }

    @FunctionalInterface
    private static interface ContentFileCreator {
        public Path createFile() throws IOException;
    }
}

