/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.mediaprocessing.model.ResourceRelatedFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

abstract class AbstractInMemoryFile
implements ResourceRelatedFile {
    private final String resourceUrl;
    private byte[] content = new byte[0];

    protected AbstractInMemoryFile(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Override
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    @Override
    public boolean hasContent() {
        return this.content.length > 0;
    }

    @Override
    public InputStream getContentStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public Long getContentSize() {
        return this.content.length;
    }

    @Override
    public void markAsNoContent() {
        this.content = new byte[0];
    }

    @Override
    public void markAsWithContent(InputStream newContent) throws IOException {
        this.content = IOUtils.toByteArray((InputStream)newContent);
    }

    @Override
    public void close() {
        this.markAsNoContent();
    }
}

