/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.http;

import eu.europeana.metis.mediaprocessing.http.AbstractHttpClient;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDownloadClient
extends AbstractHttpClient<Pair<RdfResourceEntry, DownloadMode>, Resource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceDownloadClient.class);
    private final Predicate<String> shouldDownloadMimetype;

    public ResourceDownloadClient(int maxRedirectCount, Predicate<String> shouldDownloadMimetype, int connectTimeout, int socketTimeout, int downloadTimeout) {
        super(maxRedirectCount, connectTimeout, socketTimeout, downloadTimeout);
        this.shouldDownloadMimetype = shouldDownloadMimetype;
    }

    public Resource downloadWithContent(RdfResourceEntry resourceEntry) throws IOException {
        return (Resource)this.download(new ImmutablePair((Object)resourceEntry, (Object)DownloadMode.ALWAYS));
    }

    public Resource downloadWithoutContent(RdfResourceEntry resourceEntry) throws IOException {
        return (Resource)this.download(new ImmutablePair((Object)resourceEntry, (Object)DownloadMode.NEVER));
    }

    public Resource downloadBasedOnMimeType(RdfResourceEntry resourceEntry) throws IOException {
        return (Resource)this.download(new ImmutablePair((Object)resourceEntry, (Object)DownloadMode.MIME_TYPE));
    }

    @Override
    protected String getResourceUrl(Pair<RdfResourceEntry, DownloadMode> resourceEntry) {
        return ((RdfResourceEntry)resourceEntry.getLeft()).getResourceUrl();
    }

    @Override
    protected Resource createResult(Pair<RdfResourceEntry, DownloadMode> input, URI actualUri, String mimeType, Long fileSize, AbstractHttpClient.ContentRetriever contentRetriever) throws IOException {
        RdfResourceEntry resourceEntry = (RdfResourceEntry)input.getLeft();
        ResourceImpl resource = new ResourceImpl(resourceEntry, mimeType, fileSize, actualUri);
        boolean fullDownload = input.getRight() == DownloadMode.ALWAYS || input.getRight() == DownloadMode.MIME_TYPE && this.shouldDownloadMimetype.test(mimeType);
        try {
            if (fullDownload) {
                LOGGER.debug("Starting download of resource: {}", (Object)resourceEntry.getResourceUrl());
                ResourceDownloadClient.downloadResource(resourceEntry.getResourceUrl(), resource, contentRetriever);
                LOGGER.debug("Finished download of resource: {}", (Object)resourceEntry.getResourceUrl());
            } else {
                LOGGER.debug("Download mode {} and media type {} - choosing not to download resource: {}", new Object[]{input.getRight(), mimeType, resourceEntry.getResourceUrl()});
                resource.markAsNoContent();
            }
        }
        catch (IOException | RuntimeException e) {
            resource.close();
            throw e;
        }
        return resource;
    }

    private static void downloadResource(String resourceUrl, Resource resource, AbstractHttpClient.ContentRetriever contentRetriever) throws IOException {
        try (InputStream inputStream = contentRetriever.getContent();){
            resource.markAsWithContent(inputStream);
        }
        if (resource.getContentSize() == 0L) {
            throw new IOException("Download failed of resource " + resourceUrl + ": no content found.");
        }
    }

    public static enum DownloadMode {
        ALWAYS,
        NEVER,
        MIME_TYPE;

    }
}

