/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.corelib.definitions.jibx.ColorSpaceType;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.extraction.ColorSpaceMapping;
import eu.europeana.metis.mediaprocessing.extraction.ImageMetadata;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.extraction.ThumbnailGenerator;
import eu.europeana.metis.mediaprocessing.model.ImageResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResultImpl;
import eu.europeana.metis.mediaprocessing.model.Thumbnail;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

class ImageProcessor
implements MediaProcessor {
    private final ThumbnailGenerator thumbnailGenerator;

    ImageProcessor(ThumbnailGenerator thumbnailGenerator) {
        this.thumbnailGenerator = thumbnailGenerator;
    }

    @Override
    public boolean downloadResourceForFullProcessing() {
        return true;
    }

    @Override
    public ResourceExtractionResultImpl copyMetadata(Resource resource, String detectedMimeType) throws MediaExtractionException {
        return new ResourceExtractionResultImpl(new ImageResourceMetadata(detectedMimeType, resource.getResourceUrl(), resource.getProvidedFileSize()));
    }

    @Override
    public ResourceExtractionResultImpl extractMetadata(Resource resource, String detectedMimeType) throws MediaExtractionException {
        long contentSize;
        try {
            if (!resource.hasContent()) {
                throw new MediaExtractionException("File does not exist or does not have content.");
            }
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine whether resource has content.", e);
        }
        try {
            contentSize = resource.getContentSize();
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine the size of the resource " + resource.getResourceUrl(), e);
        }
        Pair<ImageMetadata, List<Thumbnail>> thumbnailsAndMetadata = this.thumbnailGenerator.generateThumbnails(resource.getResourceUrl(), detectedMimeType, resource.getContentFile());
        ImageMetadata imageMetadata = (ImageMetadata)thumbnailsAndMetadata.getLeft();
        ColorSpaceType colorSpace = ColorSpaceMapping.getColorSpaceType(imageMetadata.getColorSpace());
        ImageResourceMetadata resourceMetadata = new ImageResourceMetadata(detectedMimeType, resource.getResourceUrl(), contentSize, imageMetadata.getWidth(), imageMetadata.getHeight(), colorSpace, imageMetadata.getDominantColors(), (List)thumbnailsAndMetadata.getRight());
        return new ResourceExtractionResultImpl(resourceMetadata, (List)thumbnailsAndMetadata.getRight());
    }
}

