/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.exception.CommandExecutionException;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.CommandExecutor;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.model.AbstractResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.AudioResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResultImpl;
import eu.europeana.metis.mediaprocessing.model.VideoResourceMetadata;
import eu.europeana.metis.utils.MediaType;
import io.lindstrom.mpd.MPDParser;
import io.lindstrom.mpd.data.AdaptationSet;
import io.lindstrom.mpd.data.FrameRate;
import io.lindstrom.mpd.data.MPD;
import io.lindstrom.mpd.data.Period;
import io.lindstrom.mpd.data.Representation;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AudioVideoProcessor
implements MediaProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AudioVideoProcessor.class);
    private static String globalFfprobeCommand;
    private final CommandExecutor commandExecutor;
    private final String ffprobeCommand;

    AudioVideoProcessor(CommandExecutor commandExecutor) throws MediaProcessorException {
        this(commandExecutor, AudioVideoProcessor.getGlobalFfprobeCommand(commandExecutor));
    }

    AudioVideoProcessor(CommandExecutor commandExecutor, String ffprobeCommand) {
        this.commandExecutor = commandExecutor;
        this.ffprobeCommand = ffprobeCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getGlobalFfprobeCommand(CommandExecutor commandExecutor) throws MediaProcessorException {
        Class<AudioVideoProcessor> clazz = AudioVideoProcessor.class;
        synchronized (AudioVideoProcessor.class) {
            if (globalFfprobeCommand == null) {
                globalFfprobeCommand = AudioVideoProcessor.discoverFfprobeCommand(commandExecutor);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return globalFfprobeCommand;
        }
    }

    static String discoverFfprobeCommand(CommandExecutor commandExecutor) throws MediaProcessorException {
        String output;
        try {
            output = String.join((CharSequence)"", commandExecutor.execute(Collections.singletonList("ffprobe"), true));
        }
        catch (CommandExecutionException e) {
            throw new MediaProcessorException("Error while looking for ffprobe tools", e);
        }
        if (!output.startsWith("ffprobe version 2") && !output.startsWith("ffprobe version 3")) {
            throw new MediaProcessorException("ffprobe 2.x/3.x not found");
        }
        return "ffprobe";
    }

    private static boolean resourceHasContent(Resource resource) throws MediaExtractionException {
        try {
            return resource.hasContent();
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine whether resource has content.", e);
        }
    }

    private static String validateUrl(String url) throws MediaExtractionException {
        try {
            return new URI(url).toURL().toString();
        }
        catch (RuntimeException | MalformedURLException | URISyntaxException e) {
            throw new MediaExtractionException("Could not validate URL: " + url, e);
        }
    }

    List<String> createAudioVideoAnalysisCommand(Resource resource) throws MediaExtractionException {
        String resourceLocation = AudioVideoProcessor.resourceHasContent(resource) ? resource.getContentPath().toString() : AudioVideoProcessor.validateUrl(resource.getResourceUrl());
        return Arrays.asList(this.ffprobeCommand, "-v", "quiet", "-print_format", "json", "-show_format", "-show_streams", "-hide_banner", resourceLocation);
    }

    @Override
    public boolean downloadResourceForFullProcessing() {
        return false;
    }

    @Override
    public ResourceExtractionResultImpl copyMetadata(Resource resource, String detectedMimeType) {
        AbstractResourceMetadata metadata;
        switch (MediaType.getMediaType((String)detectedMimeType)) {
            case AUDIO: {
                metadata = new AudioResourceMetadata(detectedMimeType, resource.getResourceUrl(), resource.getProvidedFileSize());
                break;
            }
            case VIDEO: {
                metadata = new VideoResourceMetadata(detectedMimeType, resource.getResourceUrl(), resource.getProvidedFileSize());
                break;
            }
            default: {
                metadata = null;
            }
        }
        return metadata == null ? null : new ResourceExtractionResultImpl(metadata);
    }

    @Override
    public ResourceExtractionResultImpl extractMetadata(Resource resource, String detectedMimeType) throws MediaExtractionException {
        AbstractResourceMetadata metadata;
        if ("application/dash+xml".equals(detectedMimeType)) {
            metadata = this.parseMpdResource(resource, detectedMimeType);
        } else {
            List<String> response;
            try {
                response = this.commandExecutor.execute(this.createAudioVideoAnalysisCommand(resource), false);
            }
            catch (CommandExecutionException e) {
                throw new MediaExtractionException("Problem while analyzing audio/video file.", e);
            }
            metadata = this.parseCommandResponse(resource, detectedMimeType, response);
        }
        return new ResourceExtractionResultImpl(metadata, null);
    }

    AbstractResourceMetadata parseMpdResource(Resource resource, String detectedMimeType) throws MediaExtractionException {
        VideoResourceMetadata metadata;
        MPDParser parser = new MPDParser();
        try (InputStream inputStream = resource.getActualLocation().toURL().openStream();){
            MPD mpd = parser.parse(inputStream);
            Period period = (Period)mpd.getPeriods().stream().findFirst().orElseThrow(() -> new MediaExtractionException("Cannot find period element in mpd"));
            AdaptationSet videoAdaptationSet = period.getAdaptationSets().stream().filter(adaptationSet -> {
                boolean video = false;
                if (adaptationSet.getMimeType() != null) {
                    video = adaptationSet.getMimeType().startsWith("video");
                } else if (adaptationSet.getContentType() != null) {
                    video = adaptationSet.getContentType().startsWith("video");
                }
                return video;
            }).findFirst().orElseThrow(() -> new MediaExtractionException("Cannot find video adaptation set element in mpd"));
            Representation videoRepresentation = (Representation)videoAdaptationSet.getRepresentations().get(0);
            if (videoAdaptationSet.getRepresentations().size() > 1 && (videoRepresentation = (Representation)videoAdaptationSet.getRepresentations().stream().filter(representation -> representation.getWidth() != null && representation.getHeight() != null).max(Comparator.comparing(representation -> representation.getWidth() * representation.getHeight())).orElse(null)) == null) {
                videoRepresentation = videoAdaptationSet.getRepresentations().stream().filter(representation -> representation.getMimeType() != null && representation.getMimeType().startsWith("video") || representation.getWidth() != null || representation.getHeight() != null).findFirst().orElseThrow(() -> new MediaExtractionException("Cannot find video representation element in mpd"));
            }
            Duration mediaPresentationDuration = mpd.getMediaPresentationDuration();
            Long width = videoRepresentation.getWidth() == null ? videoAdaptationSet.getWidth() : videoRepresentation.getWidth();
            Long height = videoRepresentation.getHeight() == null ? videoAdaptationSet.getHeight() : videoRepresentation.getHeight();
            FrameRate frameRate = videoRepresentation.getFrameRate() == null ? videoAdaptationSet.getFrameRate() : videoRepresentation.getFrameRate();
            double frameRateValue = frameRate == null ? -1.0 : (double)frameRate.getNumerator();
            String codecNames = videoRepresentation.getCodecs() == null ? videoAdaptationSet.getCodecs() : videoRepresentation.getCodecs();
            double bitRate = videoRepresentation.getBandwidth();
            metadata = new VideoResourceMetadata(detectedMimeType, resource.getResourceUrl(), null, Double.valueOf(mediaPresentationDuration.getSeconds()), (int)bitRate, Math.toIntExact(width), Math.toIntExact(height), codecNames, frameRateValue);
        }
        catch (IOException e) {
            throw new MediaExtractionException("Problem while analyzing audio/video file.", e);
        }
        return metadata;
    }

    JSONObject readCommandResponseToJson(List<String> response) {
        String jsonString = String.join((CharSequence)"", response);
        return new JSONObject(new JSONTokener(jsonString));
    }

    AbstractResourceMetadata parseCommandResponse(Resource resource, String detectedMimeType, List<String> response) throws MediaExtractionException {
        try {
            AbstractResourceMetadata metadata;
            JSONObject result = this.readCommandResponseToJson(response);
            if (!AudioVideoProcessor.resourceHasContent(resource) && result.length() == 0) {
                throw new MediaExtractionException("Analysis of this media file revealed no metadata. Probably it could not be downloaded.");
            }
            JSONObject format = result.getJSONObject("format");
            JSONObject videoStream = this.findStream(result, "video");
            JSONObject audioStream = this.findStream(result, "audio");
            boolean isAudio = audioStream != null;
            boolean isVideo = videoStream != null;
            long fileSize = format.getLong("size");
            if (isVideo) {
                JSONObject[] candidates = new JSONObject[]{videoStream, format};
                double duration = this.findDouble("duration", candidates);
                int bitRate = this.findInt("bit_rate", candidates);
                int width = this.findInt("width", candidates);
                int height = this.findInt("height", candidates);
                String codecName = this.findString("codec_name", candidates);
                String[] frameRateParts = this.findString("avg_frame_rate", candidates).split("/");
                double frameRate = Double.parseDouble(frameRateParts[0]) / Double.parseDouble(frameRateParts[1]);
                metadata = new VideoResourceMetadata(detectedMimeType, resource.getResourceUrl(), fileSize, duration, bitRate, width, height, codecName, frameRate);
            } else if (isAudio) {
                JSONObject[] candidates = new JSONObject[]{audioStream, format};
                double duration = this.findDouble("duration", candidates);
                int bitRate = this.findInt("bit_rate", candidates);
                int channels = this.findInt("channels", candidates);
                int sampleRate = this.findInt("sample_rate", candidates);
                int sampleSize = this.findInt("bits_per_sample", candidates);
                String codecName = this.findString("codec_name", candidates);
                metadata = new AudioResourceMetadata(detectedMimeType, resource.getResourceUrl(), fileSize, duration, bitRate, channels, sampleRate, sampleSize, codecName);
            } else {
                throw new MediaExtractionException("No media streams");
            }
            return metadata;
        }
        catch (RuntimeException e) {
            LOGGER.info("Could not parse ffprobe response:\n" + StringUtils.join(response, (String)"\n"), (Throwable)e);
            throw new MediaExtractionException("File seems to be corrupted", e);
        }
    }

    int findInt(String key, JSONObject[] candidates) {
        return this.findValue(key, candidates, candidate -> candidate.optInt(key, Integer.MIN_VALUE), value -> Integer.MIN_VALUE != value);
    }

    double findDouble(String key, JSONObject[] candidates) {
        return this.findValue(key, candidates, candidate -> candidate.optDouble(key, Double.NaN), value -> !value.isNaN());
    }

    String findString(String key, JSONObject[] candidates) {
        return this.findValue(key, candidates, candidate -> candidate.optString(key, ""), StringUtils::isNotBlank);
    }

    <T> T findValue(String key, JSONObject[] candidates, Function<JSONObject, T> valueGetter, Predicate<T> valueValidator) {
        return Stream.of(candidates).map(valueGetter).filter(valueValidator).findFirst().orElseThrow(() -> new JSONException("Could not find value for field: " + key));
    }

    JSONObject findStream(JSONObject data, String codecType) {
        for (Object streamObject : data.getJSONArray("streams")) {
            JSONObject stream = (JSONObject)streamObject;
            if (!codecType.equals(stream.getString("codec_type"))) continue;
            return stream;
        }
        return null;
    }
}

