/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing;

import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.metis.mediaprocessing.RdfBindingFactoryProvider;
import eu.europeana.metis.mediaprocessing.RdfSerializer;
import eu.europeana.metis.mediaprocessing.exception.RdfConverterException;
import eu.europeana.metis.mediaprocessing.exception.RdfSerializationException;
import eu.europeana.metis.mediaprocessing.model.EnrichedRdf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

class RdfSerializerImpl
implements RdfSerializer {
    private final IMarshallingContext context;

    RdfSerializerImpl() throws RdfConverterException {
        try {
            this.context = RdfBindingFactoryProvider.getBindingFactory().createMarshallingContext();
        }
        catch (JiBXException e) {
            throw new RdfConverterException("Problem creating serializer.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize(RDF rdf) throws RdfSerializationException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            this.serialize(rdf, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RdfSerializationException("Problem with serializing RDF.", e);
        }
    }

    private void serialize(RDF rdf, OutputStream outputStream) throws RdfSerializationException {
        try {
            this.context.marshalDocument((Object)rdf, "UTF-8", null, outputStream);
        }
        catch (JiBXException e) {
            throw new RdfSerializationException("Problem with serializing RDF.", e);
        }
    }

    @Override
    public byte[] serialize(EnrichedRdf rdf) throws RdfSerializationException {
        return this.serialize(rdf.finalizeRdf());
    }

    @Override
    public void serialize(EnrichedRdf rdf, OutputStream outputStream) throws RdfSerializationException {
        this.serialize(rdf.finalizeRdf(), outputStream);
    }
}

