/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing;

import eu.europeana.metis.mediaprocessing.RdfDeserializerImpl;
import eu.europeana.metis.mediaprocessing.exception.RdfConverterException;
import eu.europeana.metis.mediaprocessing.exception.RdfDeserializationException;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class RdfDeserializerWithXPath
extends RdfDeserializerImpl {
    private final XPathExpression getObjectExpression;
    private final XPathExpression getHasViewExpression;
    private final XPathExpression getIsShownAtExpression;
    private final XPathExpression getIsShownByExpression;

    RdfDeserializerWithXPath() throws RdfConverterException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new RdfNamespaceContext());
        try {
            this.getObjectExpression = xPath.compile("/rdf:RDF/ore:Aggregation/edm:object/@rdf:resource");
            this.getHasViewExpression = xPath.compile("/rdf:RDF/ore:Aggregation/edm:hasView/@rdf:resource");
            this.getIsShownAtExpression = xPath.compile("/rdf:RDF/ore:Aggregation/edm:isShownAt/@rdf:resource");
            this.getIsShownByExpression = xPath.compile("/rdf:RDF/ore:Aggregation/edm:isShownBy/@rdf:resource");
        }
        catch (XPathExpressionException e) {
            throw new RdfConverterException("Could not initialize xpath expressions.", e);
        }
    }

    @Override
    Map<String, List<UrlType>> getResourceEntries(InputStream inputStream, Set<UrlType> allowedUrlTypes) throws RdfDeserializationException {
        Document document;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setNamespaceAware(true);
            document = factory.newDocumentBuilder().parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RdfDeserializationException("Problem with deserializing RDF.", e);
        }
        HashMap<String, List<UrlType>> urls = new HashMap<String, List<UrlType>>();
        Function<String, List> listProd = k -> new ArrayList();
        for (UrlType type : allowedUrlTypes) {
            Set<String> urlsForType = this.getUrls(document, type);
            for (String url : urlsForType) {
                urls.computeIfAbsent(url, listProd).add(type);
            }
        }
        return urls;
    }

    private Set<String> getUrls(Document document, UrlType type) throws RdfDeserializationException {
        NodeList nodes;
        XPathExpression expression;
        switch (type) {
            case OBJECT: {
                expression = this.getObjectExpression;
                break;
            }
            case HAS_VIEW: {
                expression = this.getHasViewExpression;
                break;
            }
            case IS_SHOWN_AT: {
                expression = this.getIsShownAtExpression;
                break;
            }
            case IS_SHOWN_BY: {
                expression = this.getIsShownByExpression;
                break;
            }
            default: {
                return Collections.emptySet();
            }
        }
        try {
            nodes = (NodeList)expression.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RdfDeserializationException("Problem with deserializing RDF.", e);
        }
        return IntStream.range(0, nodes.getLength()).mapToObj(nodes::item).map(Node::getNodeValue).collect(Collectors.toSet());
    }

    private static class RdfNamespaceContext
    implements NamespaceContext {
        private static final Map<String, String> PREFIX_TO_NAMESPACE_MAP = new HashMap<String, String>();

        private RdfNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String s) {
            if (s == null) {
                throw new IllegalArgumentException();
            }
            return Optional.ofNullable(PREFIX_TO_NAMESPACE_MAP.get(s)).orElse("");
        }

        @Override
        public String getPrefix(String s) {
            if (s == null) {
                throw new IllegalArgumentException();
            }
            return PREFIX_TO_NAMESPACE_MAP.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(s)).map(Map.Entry::getKey).findAny().orElse(null);
        }

        @Override
        public Iterator<String> getPrefixes(String s) {
            return Optional.ofNullable(this.getPrefix(s)).map(Collections::singletonList).orElseGet(Collections::emptyList).iterator();
        }

        static {
            PREFIX_TO_NAMESPACE_MAP.put("", "");
            PREFIX_TO_NAMESPACE_MAP.put("xml", "http://www.w3.org/XML/1998/namespace");
            PREFIX_TO_NAMESPACE_MAP.put("xmlns", "http://www.w3.org/2000/xmlns/");
            PREFIX_TO_NAMESPACE_MAP.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            PREFIX_TO_NAMESPACE_MAP.put("ore", "http://www.openarchives.org/ore/terms/");
            PREFIX_TO_NAMESPACE_MAP.put("edm", "http://www.europeana.eu/schemas/edm/");
        }
    }
}

