/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing;

import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.metis.mediaprocessing.RdfBindingFactoryProvider;
import eu.europeana.metis.mediaprocessing.RdfDeserializer;
import eu.europeana.metis.mediaprocessing.exception.RdfConverterException;
import eu.europeana.metis.mediaprocessing.exception.RdfDeserializationException;
import eu.europeana.metis.mediaprocessing.model.EnrichedRdf;
import eu.europeana.metis.mediaprocessing.model.EnrichedRdfImpl;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.RdfWrapper;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

class RdfDeserializerImpl
implements RdfDeserializer {
    private final IUnmarshallingContext context;

    RdfDeserializerImpl() throws RdfConverterException {
        try {
            this.context = RdfBindingFactoryProvider.getBindingFactory().createUnmarshallingContext();
        }
        catch (JiBXException e) {
            throw new RdfConverterException("Problem creating deserializer.", e);
        }
    }

    @Override
    public List<RdfResourceEntry> getResourceEntriesForMediaExtraction(byte[] input) throws RdfDeserializationException {
        return RdfDeserializerImpl.performDeserialization(input, this::getResourceEntriesForMediaExtraction);
    }

    @Override
    public List<RdfResourceEntry> getResourceEntriesForMediaExtraction(InputStream inputStream) throws RdfDeserializationException {
        return RdfDeserializerImpl.convertToResourceEntries(this.getResourceEntries(inputStream, UrlType.URL_TYPES_FOR_MEDIA_EXTRACTION));
    }

    @Override
    public List<String> getResourceEntriesForLinkChecking(byte[] input) throws RdfDeserializationException {
        return RdfDeserializerImpl.performDeserialization(input, this::getResourceEntriesForLinkChecking);
    }

    @Override
    public List<String> getResourceEntriesForLinkChecking(InputStream inputStream) throws RdfDeserializationException {
        return new ArrayList<String>(this.getResourceEntries(inputStream, UrlType.URL_TYPES_FOR_LINK_CHECKING).keySet());
    }

    @Override
    public EnrichedRdf getRdfForResourceEnriching(byte[] input) throws RdfDeserializationException {
        return RdfDeserializerImpl.performDeserialization(input, this::getRdfForResourceEnriching);
    }

    @Override
    public EnrichedRdf getRdfForResourceEnriching(InputStream inputStream) throws RdfDeserializationException {
        return new EnrichedRdfImpl(this.deserialize(inputStream));
    }

    Map<String, List<UrlType>> getResourceEntries(InputStream inputStream, Set<UrlType> allowedUrlTypes) throws RdfDeserializationException {
        return new RdfWrapper(this.deserialize(inputStream)).getResourceUrls(allowedUrlTypes);
    }

    private static List<RdfResourceEntry> convertToResourceEntries(Map<String, List<UrlType>> urlWithTypes) {
        return urlWithTypes.entrySet().stream().map(entry -> new RdfResourceEntry((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <R> R performDeserialization(byte[] input, DeserializationOperation<R> operation) throws RdfDeserializationException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(input);){
            R r = operation.deserialize(inputStream);
            return r;
        }
        catch (IOException e) {
            throw new RdfDeserializationException("Problem with deserializing RDF.", e);
        }
    }

    private RDF deserialize(InputStream inputStream) throws RdfDeserializationException {
        try {
            return (RDF)this.context.unmarshalDocument(inputStream, "UTF-8");
        }
        catch (JiBXException e) {
            throw new RdfDeserializationException("Problem with deserializing RDF.", e);
        }
    }

    @FunctionalInterface
    private static interface DeserializationOperation<R> {
        public R deserialize(InputStream var1) throws RdfDeserializationException;
    }
}

