/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.corelib.definitions.jibx.Aggregation;
import eu.europeana.corelib.definitions.jibx.HasView;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RdfWrapper {
    private final RDF rdf;

    public RdfWrapper(RDF rdf) {
        this.rdf = rdf;
    }

    protected RDF getRdf() {
        return this.rdf;
    }

    public Map<String, List<UrlType>> getResourceUrls(Set<UrlType> urlTypes) {
        HashMap<String, List<UrlType>> urls = new HashMap<String, List<UrlType>>();
        if (this.rdf.getAggregationList() == null) {
            return urls;
        }
        Function<String, List> listProd = k -> new ArrayList();
        for (Aggregation aggregation : this.rdf.getAggregationList()) {
            if (urlTypes.contains((Object)UrlType.OBJECT) && aggregation.getObject() != null) {
                urls.computeIfAbsent(aggregation.getObject().getResource(), listProd).add(UrlType.OBJECT);
            }
            if (urlTypes.contains((Object)UrlType.HAS_VIEW) && aggregation.getHasViewList() != null) {
                for (HasView hv : aggregation.getHasViewList()) {
                    urls.computeIfAbsent(hv.getResource(), listProd).add(UrlType.HAS_VIEW);
                }
            }
            if (urlTypes.contains((Object)UrlType.IS_SHOWN_BY) && aggregation.getIsShownBy() != null) {
                urls.computeIfAbsent(aggregation.getIsShownBy().getResource(), listProd).add(UrlType.IS_SHOWN_BY);
            }
            if (!urlTypes.contains((Object)UrlType.IS_SHOWN_AT) || aggregation.getIsShownAt() == null) continue;
            urls.computeIfAbsent(aggregation.getIsShownAt().getResource(), listProd).add(UrlType.IS_SHOWN_AT);
        }
        return urls;
    }
}

