/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.exception.CommandExecutionException;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.CommandExecutor;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.model.AbstractResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.AudioResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResult;
import eu.europeana.metis.mediaprocessing.model.VideoResourceMetadata;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AudioVideoProcessor
implements MediaProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AudioVideoProcessor.class);
    private static String globalFfprobeCommand;
    private final CommandExecutor commandExecutor;
    private final String ffprobeCommand;

    AudioVideoProcessor(CommandExecutor commandExecutor) throws MediaProcessorException {
        this(commandExecutor, AudioVideoProcessor.getGlobalFfprobeCommand(commandExecutor));
    }

    AudioVideoProcessor(CommandExecutor commandExecutor, String ffprobeCommand) {
        this.commandExecutor = commandExecutor;
        this.ffprobeCommand = ffprobeCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getGlobalFfprobeCommand(CommandExecutor commandExecutor) throws MediaProcessorException {
        Class<AudioVideoProcessor> clazz = AudioVideoProcessor.class;
        synchronized (AudioVideoProcessor.class) {
            if (globalFfprobeCommand == null) {
                globalFfprobeCommand = AudioVideoProcessor.discoverFfprobeCommand(commandExecutor);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return globalFfprobeCommand;
        }
    }

    static String discoverFfprobeCommand(CommandExecutor commandExecutor) throws MediaProcessorException {
        String output;
        try {
            output = String.join((CharSequence)"", commandExecutor.execute(Collections.singletonList("ffprobe"), true));
        }
        catch (CommandExecutionException e) {
            throw new MediaProcessorException("Error while looking for ffprobe tools", e);
        }
        if (!output.startsWith("ffprobe version 2") && !output.startsWith("ffprobe version 3")) {
            throw new MediaProcessorException("ffprobe 2.x/3.x not found");
        }
        return "ffprobe";
    }

    private static boolean resourceHasContent(Resource resource) throws MediaExtractionException {
        try {
            return resource.hasContent();
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine whether resource has content.", e);
        }
    }

    List<String> createAudioVideoAnalysisCommand(Resource resource) throws MediaExtractionException {
        String resourceLocation = AudioVideoProcessor.resourceHasContent(resource) ? resource.getContentPath().toString() : resource.getResourceUrl();
        return Arrays.asList(this.ffprobeCommand, "-v", "quiet", "-print_format", "json", "-show_format", "-show_streams", "-hide_banner", resourceLocation);
    }

    @Override
    public ResourceExtractionResult process(Resource resource, String detectedMimeType) throws MediaExtractionException {
        List<String> response;
        if (!this.shouldExtractMetadata(resource)) {
            return null;
        }
        try {
            response = this.commandExecutor.execute(this.createAudioVideoAnalysisCommand(resource), false);
        }
        catch (CommandExecutionException e) {
            throw new MediaExtractionException("Problem while analyzing audio/video file.", e);
        }
        AbstractResourceMetadata metadata = this.parseCommandResponse(resource, detectedMimeType, response);
        return new ResourceExtractionResult(metadata, null);
    }

    JSONObject readCommandResponseToJson(List<String> response) {
        String jsonString = String.join((CharSequence)"", response);
        return new JSONObject(new JSONTokener(jsonString));
    }

    AbstractResourceMetadata parseCommandResponse(Resource resource, String detectedMimeType, List<String> response) throws MediaExtractionException {
        AbstractResourceMetadata metadata;
        block5: {
            try {
                JSONObject result = this.readCommandResponseToJson(response);
                if (!AudioVideoProcessor.resourceHasContent(resource) && result.length() == 0) {
                    throw new MediaExtractionException("Probably download failed");
                }
                JSONObject format = result.getJSONObject("format");
                JSONObject videoStream = this.findStream(result, "video");
                JSONObject audioStream = this.findStream(result, "audio");
                long fileSize = format.getLong("size");
                if (videoStream != null) {
                    JSONObject[] candidates = new JSONObject[]{videoStream, format};
                    double duration = this.findDouble("duration", candidates);
                    int bitRate = this.findInt("bit_rate", candidates);
                    int width = this.findInt("width", candidates);
                    int height = this.findInt("height", candidates);
                    String codecName = this.findString("codec_name", candidates);
                    String[] frameRateParts = this.findString("avg_frame_rate", candidates).split("/");
                    double frameRate = Double.parseDouble(frameRateParts[0]) / Double.parseDouble(frameRateParts[1]);
                    metadata = new VideoResourceMetadata(detectedMimeType, resource.getResourceUrl(), fileSize, duration, bitRate, width, height, codecName, frameRate);
                    break block5;
                }
                if (audioStream != null) {
                    JSONObject[] candidates = new JSONObject[]{audioStream, format};
                    double duration = this.findDouble("duration", candidates);
                    int bitRate = this.findInt("bit_rate", candidates);
                    int channels = this.findInt("channels", candidates);
                    int sampleRate = this.findInt("sample_rate", candidates);
                    int sampleSize = this.findInt("bits_per_sample", candidates);
                    metadata = new AudioResourceMetadata(detectedMimeType, resource.getResourceUrl(), fileSize, duration, bitRate, channels, sampleRate, sampleSize);
                    break block5;
                }
                throw new MediaExtractionException("No media streams");
            }
            catch (RuntimeException e) {
                LOGGER.info("Could not parse ffprobe response:\n" + StringUtils.join(response, (String)"\n"), (Throwable)e);
                throw new MediaExtractionException("File seems to be corrupted", e);
            }
        }
        return metadata;
    }

    int findInt(String key, JSONObject[] candidates) {
        return this.findValue(key, candidates, candidate -> candidate.optInt(key, Integer.MIN_VALUE), value -> Integer.MIN_VALUE != value);
    }

    double findDouble(String key, JSONObject[] candidates) {
        return this.findValue(key, candidates, candidate -> candidate.optDouble(key, Double.NaN), value -> !value.isNaN());
    }

    String findString(String key, JSONObject[] candidates) {
        return this.findValue(key, candidates, candidate -> candidate.optString(key, ""), StringUtils::isNotBlank);
    }

    <T> T findValue(String key, JSONObject[] candidates, Function<JSONObject, T> valueGetter, Predicate<T> valueValidator) {
        return Stream.of(candidates).map(valueGetter).filter(valueValidator).findFirst().orElseThrow(() -> new JSONException("Could not find value for field: " + key));
    }

    JSONObject findStream(JSONObject data, String codecType) {
        for (Object streamObject : data.getJSONArray("streams")) {
            JSONObject stream = (JSONObject)streamObject;
            if (!codecType.equals(stream.getString("codec_type"))) continue;
            return stream;
        }
        return null;
    }
}

