/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing;

import eu.europeana.metis.mediaprocessing.LinkChecker;
import eu.europeana.metis.mediaprocessing.MediaExtractor;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.MediaExtractorImpl;
import eu.europeana.metis.mediaprocessing.linkchecking.LinkCheckerImpl;

public class MediaProcessorFactory {
    public static final int DEFAULT_MAX_REDIRECT_COUNT = 3;
    public static final int DEFAULT_THUMBNAIL_GENERATE_TIMEOUT = 30;
    public static final int DEFAULT_AUDIO_VIDEO_PROBE_TIMEOUT = 60;
    private int maxRedirectCount = 3;
    private int thumbnailGenerateTimeout = 30;
    private int audioVideoProbeTimeout = 60;

    public void setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = maxRedirectCount < 0 ? 3 : maxRedirectCount;
    }

    public void setThumbnailGenerateTimeout(int thumbnailGenerateTimeout) {
        this.thumbnailGenerateTimeout = thumbnailGenerateTimeout < 1 ? 30 : thumbnailGenerateTimeout;
    }

    public void setAudioVideoProbeTimeout(int audioVideoProbeTimeout) {
        this.audioVideoProbeTimeout = audioVideoProbeTimeout < 1 ? 60 : audioVideoProbeTimeout;
    }

    public MediaExtractor createMediaExtractor() throws MediaProcessorException {
        return MediaExtractorImpl.newInstance(this.maxRedirectCount, this.thumbnailGenerateTimeout, this.audioVideoProbeTimeout);
    }

    public LinkChecker createLinkChecker() throws MediaProcessorException {
        return new LinkCheckerImpl(this.maxRedirectCount);
    }
}

