/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service.dao;

import eu.europeana.enrichment.api.external.model.WikidataOrganization;
import eu.europeana.enrichment.service.exception.WikidataAccessException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;

public class WikidataAccessDao {
    public static final String WIKIDATA_ORGANIZATION_XSL_FILE = "/wkd2org.xsl";
    private static final String SPARQL = "https://query.wikidata.org/sparql";
    private static final int SIZE = 0x100000;
    private Transformer transformer;

    private WikidataAccessDao(InputStreamCreator inputStreamSupplier) throws WikidataAccessException {
        try (InputStream inputStream = inputStreamSupplier.create();){
            this.init(inputStream);
        }
        catch (IOException e) {
            throw new WikidataAccessException("Unexpected exception while reading the wikidata XSLT file.", e);
        }
    }

    public WikidataAccessDao(File templateFile) throws WikidataAccessException {
        this(() -> Files.newInputStream(templateFile.toPath(), new OpenOption[0]));
    }

    public WikidataAccessDao(InputStream xslTemplate) throws WikidataAccessException {
        this(() -> xslTemplate);
    }

    public WikidataAccessDao() throws WikidataAccessException {
        this(() -> WikidataAccessDao.class.getResourceAsStream(WIKIDATA_ORGANIZATION_XSL_FILE));
    }

    public final void init(InputStream xslTemplate) throws WikidataAccessException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            StreamSource xslt = new StreamSource(xslTemplate);
            this.transformer = transformerFactory.newTransformer(xslt);
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            this.transformer.setParameter("deref", Boolean.TRUE);
            this.transformer.setParameter("address", Boolean.TRUE);
        }
        catch (TransformerConfigurationException e) {
            throw new WikidataAccessException("Transformer could not be initialized.", e);
        }
    }

    public StringBuilder getEntity(String uri) throws WikidataAccessException {
        StringBuilder res = new StringBuilder();
        StreamResult wikidataRes = new StreamResult((Writer)new StringBuilderWriter(res));
        this.translate(uri, wikidataRes);
        return res;
    }

    public WikidataOrganization parse(File xmlFile) throws JAXBException, IOException {
        String xml = FileUtils.readFileToString((File)xmlFile, (Charset)StandardCharsets.UTF_8);
        return this.parse(xml);
    }

    public WikidataOrganization parse(InputStream xmlStream) throws JAXBException, IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)xmlStream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        String wikidataXml = writer.toString();
        return this.parse(wikidataXml);
    }

    public WikidataOrganization parse(String xml) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WikidataOrganization.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        return (WikidataOrganization)unmarshaller.unmarshal((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getModelFromSPARQL(String uri) throws WikidataAccessException {
        Resource resource = this.fetchFromSPARQL(uri);
        if (!this.isDuplicate(resource)) {
            return resource;
        }
        try (StmtIterator iter = resource.listProperties(OWL.sameAs);){
            while (iter.hasNext()) {
                String sameAs = ((Statement)iter.next()).getResource().getURI();
                Resource r2 = this.fetchFromSPARQL(sameAs);
                if (this.isDuplicate(r2)) continue;
                resource = r2;
                break;
            }
        }
        return resource;
    }

    private boolean isDuplicate(Resource resource) {
        return resource != null && resource.hasProperty(OWL.sameAs) && !resource.hasProperty(RDFS.label);
    }

    private Resource fetchFromSPARQL(String uri) throws WikidataAccessException {
        Resource resource;
        String sDescribe = "DESCRIBE <" + uri + ">";
        Model m = ModelFactory.createDefaultModel();
        QueryEngineHTTP endpoint = new QueryEngineHTTP(SPARQL, sDescribe);
        try {
            resource = endpoint.execDescribe(m).getResource(uri);
        }
        catch (Throwable throwable) {
            try {
                try {
                    endpoint.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                throw new WikidataAccessException("Cannot access wikidata resource: " + uri, e);
            }
        }
        endpoint.close();
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(Resource resource, StreamResult res) throws WikidataAccessException {
        WikidataAccessDao wikidataAccessDao = this;
        synchronized (wikidataAccessDao) {
            this.transformer.setParameter("rdf_about", resource.getURI());
            StringBuilder sb = new StringBuilder(0x100000);
            try (StringBuilderWriter sbw = new StringBuilderWriter(sb);){
                Model model = resource.getModel();
                RDFWriter writer = model.getWriter("RDF/XML");
                writer.setProperty("tab", (Object)"0");
                writer.setProperty("allowBadURIs", (Object)"true");
                writer.setProperty("relativeURIs", (Object)"");
                writer.write(model, (Writer)sbw, "RDF/XML");
                this.transformer.transform(new StreamSource((Reader)new CharSequenceReader((CharSequence)sb)), res);
            }
            catch (TransformerException e) {
                throw new WikidataAccessException("Error by transforming of Wikidata in RDF/XML.", e);
            }
            finally {
                sb.setLength(0);
            }
        }
    }

    public WikidataOrganization parseWikidataOrganization(File inputFile) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WikidataOrganization.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return (WikidataOrganization)unmarshaller.unmarshal(inputFile);
    }

    public void translate(String uri, StreamResult res) throws WikidataAccessException {
        Resource wikidataResource = this.getModelFromSPARQL(uri);
        if (wikidataResource == null || wikidataResource.getURI() == null) {
            throw new WikidataAccessException("Cannot access wikidata resource: " + uri, null);
        }
        this.transform(wikidataResource, res);
    }

    @FunctionalInterface
    private static interface InputStreamCreator {
        public InputStream create() throws IOException;
    }
}

