/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service.dao;

import com.mongodb.client.MongoClient;
import dev.morphia.Datastore;
import dev.morphia.DeleteOptions;
import dev.morphia.Morphia;
import dev.morphia.mapping.DiscriminatorFunction;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.NamingStrategy;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import eu.europeana.enrichment.internal.model.AbstractEnrichmentEntity;
import eu.europeana.enrichment.internal.model.EnrichmentTerm;
import eu.europeana.enrichment.utils.EntityType;
import eu.europeana.metis.mongo.utils.MorphiaUtils;
import eu.europeana.metis.network.ExternalRequestUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.types.ObjectId;

public class EnrichmentDao {
    private final Datastore datastore;
    public static final String ID_FIELD = "_id";
    public static final String ENTITY_TYPE_FIELD = "entityType";
    public static final String ENTITY_ABOUT_FIELD = "enrichmentEntity.about";
    public static final String ENTITY_OWL_SAME_AS_FIELD = "enrichmentEntity.owlSameAs";
    private static final String UPDATED_FIELD = "updated";
    public static final String LABEL_INFOS_FIELD = "labelInfos";
    public static final String LABEL_FIELD = "lowerCaseLabel";
    public static final String LANG_FIELD = "lang";

    public EnrichmentDao(MongoClient mongoClient, String databaseName) {
        MapperOptions mapperOptions = MapperOptions.builder().discriminatorKey("className").discriminator(DiscriminatorFunction.className()).collectionNaming(NamingStrategy.identity()).build();
        this.datastore = Morphia.createDatastore((MongoClient)mongoClient, (String)databaseName, (MapperOptions)mapperOptions);
        Mapper mapper = this.datastore.getMapper();
        mapper.map(new Class[]{EnrichmentTerm.class});
        this.datastore.ensureIndexes();
    }

    public Optional<EnrichmentTerm> getEnrichmentTermByField(String fieldName, String fieldValue) {
        return (Optional)ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> Optional.ofNullable((EnrichmentTerm)this.datastore.find(EnrichmentTerm.class).filter(new Filter[]{Filters.eq((String)fieldName, (Object)fieldValue)}).first()));
    }

    public Optional<ObjectId> getEnrichmentTermObjectIdByField(String fieldName, String fieldValue) {
        return (Optional)ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> {
            Optional<EnrichmentTerm> enrichmentTerm = Optional.ofNullable((EnrichmentTerm)this.datastore.find(EnrichmentTerm.class).filter(new Filter[]{Filters.eq((String)fieldName, (Object)fieldValue)}).first(new FindOptions().projection().include(new String[]{ID_FIELD})));
            return enrichmentTerm.map(EnrichmentTerm::getId);
        });
    }

    public List<EnrichmentTerm> getAllEnrichmentTermsByFields(Map<String, List<Pair<String, String>>> containingListFieldNameAndValues) {
        Query query = this.datastore.find(EnrichmentTerm.class);
        for (Map.Entry<String, List<Pair<String, String>>> entry : containingListFieldNameAndValues.entrySet()) {
            ArrayList<Filter> filters = new ArrayList<Filter>(entry.getValue().size());
            for (Pair<String, String> fieldNameAndValue : entry.getValue()) {
                filters.add(Filters.eq((String)((String)fieldNameAndValue.getKey()), (Object)fieldNameAndValue.getValue()));
            }
            if (StringUtils.isNotBlank((CharSequence)entry.getKey())) {
                query.filter(new Filter[]{Filters.elemMatch((String)entry.getKey(), (Filter[])((Filter[])filters.toArray(Filter[]::new)))});
                continue;
            }
            query.filter((Filter[])filters.toArray(Filter[]::new));
        }
        return MorphiaUtils.getListOfQueryRetryable((Query)query);
    }

    public List<EnrichmentTerm> getAllEnrichmentTermsByFieldsInList(List<Pair<String, List<String>>> fieldNameAndValues) {
        Query query = this.datastore.find(EnrichmentTerm.class);
        for (Pair<String, List<String>> fieldNameAndValue : fieldNameAndValues) {
            query.filter(new Filter[]{Filters.in((String)((String)fieldNameAndValue.getKey()), (Iterable)((Iterable)fieldNameAndValue.getValue()))});
        }
        return MorphiaUtils.getListOfQueryRetryable((Query)query);
    }

    public Date getDateOfLastUpdatedEnrichmentTerm(EntityType entityType) {
        Query query = this.datastore.find(EnrichmentTerm.class);
        query.filter(new Filter[]{Filters.eq((String)ENTITY_TYPE_FIELD, (Object)entityType)});
        EnrichmentTerm enrichmentTerm = (EnrichmentTerm)ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> (EnrichmentTerm)query.first(new FindOptions().sort(new Sort[]{Sort.descending((String)UPDATED_FIELD)})));
        Date dateUpdated = null;
        if (Objects.nonNull(enrichmentTerm)) {
            dateUpdated = enrichmentTerm.getUpdated();
        }
        return dateUpdated;
    }

    public String saveEnrichmentTerm(EnrichmentTerm enrichmentTerm) {
        EnrichmentTerm enrichmentTermSaved = (EnrichmentTerm)ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> (EnrichmentTerm)this.datastore.save((Object)enrichmentTerm));
        return enrichmentTermSaved == null ? "" : enrichmentTermSaved.getId().toString();
    }

    public List<String> deleteEnrichmentTerms(EntityType entityType, List<String> entityAbout) {
        this.deleteEnrichmentTerms(entityAbout);
        Query enrichmentTermsSameAsQuery = this.datastore.find(EnrichmentTerm.class).filter(new Filter[]{Filters.eq((String)ENTITY_TYPE_FIELD, (Object)entityType)}).filter(new Filter[]{Filters.in((String)ENTITY_OWL_SAME_AS_FIELD, entityAbout)});
        List enrichmentTermsOwlSameAs = MorphiaUtils.getListOfQueryRetryable((Query)enrichmentTermsSameAsQuery);
        List<String> sameAsUris = enrichmentTermsOwlSameAs.stream().map(EnrichmentTerm::getEnrichmentEntity).map(AbstractEnrichmentEntity::getAbout).collect(Collectors.toList());
        this.deleteEnrichmentTerms(sameAsUris);
        return sameAsUris;
    }

    private void deleteEnrichmentTerms(List<String> entityAbout) {
        ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> this.datastore.find(EnrichmentTerm.class).filter(new Filter[]{Filters.in((String)ENTITY_ABOUT_FIELD, (Iterable)entityAbout)}).delete(new DeleteOptions().multi(true)));
    }
}

