/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.corelib.definitions.edm.entity.Address;
import eu.europeana.corelib.solr.entity.AddressImpl;
import eu.europeana.corelib.solr.entity.OrganizationImpl;
import eu.europeana.enrichment.api.external.model.EdmOrganization;
import eu.europeana.enrichment.api.external.model.VcardAddress;
import eu.europeana.enrichment.api.external.model.WikidataOrganization;
import eu.europeana.enrichment.service.EntityConverterUtils;
import eu.europeana.enrichment.service.dao.WikidataAccessDao;
import eu.europeana.enrichment.service.exception.WikidataAccessException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class WikidataAccessService {
    public static final String WIKIDATA_BASE_URL = "http://www.wikidata.org/entity/Q";
    private static final Logger LOGGER = LoggerFactory.getLogger(WikidataAccessService.class);
    private final WikidataAccessDao wikidataAccessDao;

    public WikidataAccessService(WikidataAccessDao wikidataAccessDao) {
        this.wikidataAccessDao = wikidataAccessDao;
    }

    protected WikidataAccessDao getWikidataAccessDao() {
        return this.wikidataAccessDao;
    }

    public URI buildOrganizationUri(String organizationId) {
        String contactsSearchUrl = String.format("%s%s", WIKIDATA_BASE_URL, organizationId);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)contactsSearchUrl);
        URI uri = builder.build().encode().toUri();
        return uri;
    }

    public OrganizationImpl dereference(String wikidataUri) throws WikidataAccessException {
        WikidataOrganization wikidataOrganization;
        StringBuilder wikidataXml = null;
        try {
            wikidataXml = this.getWikidataAccessDao().getEntity(wikidataUri);
            wikidataOrganization = this.getWikidataAccessDao().parse(wikidataXml.toString());
        }
        catch (JAXBException e) {
            LOGGER.debug("Cannot parse wikidata response: {}", (Object)wikidataXml);
            throw new WikidataAccessException("Cannot parse wikidata xml response for uri: " + wikidataUri, e);
        }
        if (wikidataOrganization == null) {
            return null;
        }
        return this.toOrganizationImpl(wikidataOrganization);
    }

    public WikidataOrganization parseWikidataOrganization(File inputFile) throws JAXBException {
        return this.wikidataAccessDao.parseWikidataOrganization(inputFile);
    }

    public OrganizationImpl toOrganizationImpl(WikidataOrganization wikidataOrganization) {
        String logo;
        String about;
        OrganizationImpl org = new OrganizationImpl();
        EdmOrganization edmOrganization = wikidataOrganization.getOrganization();
        if (edmOrganization.getAbout() != null && StringUtils.isNotEmpty((CharSequence)(about = edmOrganization.getAbout()))) {
            org.setAbout(about);
        }
        if (edmOrganization.getCountry() != null) {
            String country = edmOrganization.getCountry();
            org.setEdmCountry(EntityConverterUtils.createMap(Locale.ENGLISH.getLanguage(), country));
        }
        if (edmOrganization.getHomepage() != null) {
            String homepage = edmOrganization.getHomepage().getResource();
            org.setFoafHomepage(homepage);
        }
        if (edmOrganization.getLogo() != null) {
            logo = edmOrganization.getLogo().getResource();
            org.setFoafLogo(logo);
        }
        if (edmOrganization.getDepiction() != null) {
            String depiction = edmOrganization.getDepiction().getResource();
            org.setFoafDepiction(depiction);
        }
        if (edmOrganization.getMbox() != null) {
            String mbox = edmOrganization.getMbox();
            org.setFoafMbox(EntityConverterUtils.createList(mbox));
        }
        if (edmOrganization.getPhone() != null) {
            String phone = edmOrganization.getPhone();
            org.setFoafPhone(EntityConverterUtils.createList(phone));
        }
        if (edmOrganization.getLogo() != null) {
            logo = edmOrganization.getLogo().getResource();
            org.setFoafLogo(logo);
        }
        List acronymLabel = edmOrganization.getAcronyms();
        org.setEdmAcronym(EntityConverterUtils.createMapWithListsFromTextPropertyListMerging(acronymLabel));
        List sameAs = edmOrganization.getSameAs();
        org.setOwlSameAs(EntityConverterUtils.createStringArrayFromPartList(sameAs));
        List descriptions = edmOrganization.getDescriptions();
        org.setDcDescription(EntityConverterUtils.createMapFromTextPropertyList(descriptions));
        List prefLabel = edmOrganization.getPrefLabelList();
        org.setPrefLabel(EntityConverterUtils.createMapWithListsFromTextPropertyListNonMerging(prefLabel));
        List altLabel = edmOrganization.getAltLabelList();
        org.setAltLabel(EntityConverterUtils.createMapWithListsFromTextPropertyListMerging(altLabel));
        if (edmOrganization.getHasAddress() != null && edmOrganization.getHasAddress().getVcardAddressesList() != null) {
            VcardAddress vcardAddress = (VcardAddress)edmOrganization.getHasAddress().getVcardAddressesList().get(0);
            AddressImpl addressImpl = new AddressImpl();
            addressImpl.setAbout(org.getAbout() + "#address");
            addressImpl.setVcardCountryName(vcardAddress.getCountryName());
            if (vcardAddress.getHasGeo() != null) {
                addressImpl.setVcardHasGeo(vcardAddress.getHasGeo().getResource());
            }
            org.setAddress((Address)addressImpl);
        }
        return org;
    }

    public void saveXmlToFile(String xml, File contentFile) throws WikidataAccessException {
        try {
            boolean wasFileCreated = contentFile.createNewFile();
            if (!wasFileCreated) {
                LOGGER.warn("Content file existed, it will be overwritten: {}", (Object)contentFile.getAbsolutePath());
            }
            FileUtils.write((File)contentFile, (CharSequence)xml, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new WikidataAccessException("XML could not be written to a file.", e);
        }
    }

    public void mergePropsFromWikidata(OrganizationImpl zohoOrganization, OrganizationImpl wikidataOrganization) {
        HashMap<String, List<String>> addToAltLabelMap = new HashMap<String, List<String>>();
        Map<String, List<String>> newPrefLabelMap = EntityConverterUtils.mergeMapsWithSingletonLists(zohoOrganization.getPrefLabel(), wikidataOrganization.getPrefLabel(), addToAltLabelMap);
        zohoOrganization.setPrefLabel(newPrefLabelMap);
        Map<String, List<String>> allWikidataAltLabels = EntityConverterUtils.mergeMapsWithLists(wikidataOrganization.getAltLabel(), addToAltLabelMap);
        Map<String, List<String>> mergedAltLabelMap = EntityConverterUtils.mergeMapsWithLists(allWikidataAltLabels, zohoOrganization.getAltLabel());
        zohoOrganization.setAltLabel(mergedAltLabelMap);
        Map<String, List<String>> acronyms = EntityConverterUtils.mergeMapsWithLists(zohoOrganization.getEdmAcronym(), wikidataOrganization.getEdmAcronym());
        zohoOrganization.setEdmAcronym(acronyms);
        if (StringUtils.isEmpty((CharSequence)zohoOrganization.getFoafLogo())) {
            zohoOrganization.setFoafLogo(wikidataOrganization.getFoafLogo());
        }
        if (StringUtils.isEmpty((CharSequence)zohoOrganization.getFoafDepiction())) {
            zohoOrganization.setFoafDepiction(wikidataOrganization.getFoafDepiction());
        }
        if (StringUtils.isEmpty((CharSequence)zohoOrganization.getFoafHomepage())) {
            zohoOrganization.setFoafLogo(wikidataOrganization.getFoafLogo());
        }
        List<String> phoneList = EntityConverterUtils.mergeStringLists(zohoOrganization.getFoafPhone(), wikidataOrganization.getFoafPhone());
        zohoOrganization.setFoafPhone(phoneList);
        List<String> mbox = EntityConverterUtils.mergeStringLists(zohoOrganization.getFoafMbox(), wikidataOrganization.getFoafMbox());
        zohoOrganization.setFoafMbox(mbox);
        String[] sameAs = this.buildSameAs(zohoOrganization, wikidataOrganization);
        zohoOrganization.setOwlSameAs(sameAs);
        zohoOrganization.setDcDescription(wikidataOrganization.getDcDescription());
        EntityConverterUtils.mergeAddress(zohoOrganization, wikidataOrganization);
    }

    private String[] buildSameAs(OrganizationImpl zohoOrganization, OrganizationImpl wikidataOrganization) {
        String wikidataResourceUri;
        Object[] sameAs = EntityConverterUtils.mergeStringArrays(zohoOrganization.getOwlSameAs(), wikidataOrganization.getOwlSameAs());
        if (!ArrayUtils.contains((Object[])sameAs, (Object)(wikidataResourceUri = wikidataOrganization.getAbout()))) {
            sameAs = (String[])ArrayUtils.add((Object[])sameAs, (Object)wikidataResourceUri);
        }
        return sameAs;
    }
}

