/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.internal.EntityResolver;
import eu.europeana.enrichment.api.internal.ReferenceTerm;
import eu.europeana.enrichment.api.internal.SearchTerm;
import eu.europeana.enrichment.internal.model.EnrichmentTerm;
import eu.europeana.enrichment.internal.model.OrganizationEnrichmentEntity;
import eu.europeana.enrichment.service.Converter;
import eu.europeana.enrichment.service.EntityConverterUtils;
import eu.europeana.enrichment.service.dao.EnrichmentDao;
import eu.europeana.enrichment.utils.EntityType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentEntityResolver.class);
    private static final Set<String> ALL_2CODE_LANGUAGES;
    private static final Map<String, String> ALL_3CODE_TO_2CODE_LANGUAGES;
    private static final Pattern PATTERN_MATCHING_VERY_BROAD_TIMESPANS;
    public static final int THREE_CHARACTER_LANGUAGE_LENGTH = 3;
    public static final int TWO_CHARACTER_LANGUAGE_LENGTH = 2;
    private final EnrichmentDao enrichmentDao;

    public PersistentEntityResolver(EnrichmentDao enrichmentDao) {
        this.enrichmentDao = enrichmentDao;
    }

    public <T extends SearchTerm> Map<T, List<EnrichmentBase>> resolveByText(Set<T> searchTerms) {
        HashMap result = new HashMap();
        try {
            for (SearchTerm searchTerm : searchTerms) {
                this.findEnrichmentEntitiesBySearchTerm(result, searchTerm);
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Unable to retrieve entity from tag", (Throwable)e);
        }
        return result;
    }

    public <T extends ReferenceTerm> Map<T, EnrichmentBase> resolveById(Set<T> referenceTerms) {
        HashMap<ReferenceTerm, EnrichmentBase> result = new HashMap<ReferenceTerm, EnrichmentBase>();
        for (ReferenceTerm value : referenceTerms) {
            try {
                List<EnrichmentBase> foundEnrichmentBases = this.getEnrichmentTermsAndConvert(List.of(new ImmutablePair((Object)"enrichmentEntity.about", (Object)value.getReference().toString())));
                if (foundEnrichmentBases.isEmpty()) continue;
                result.put(value, foundEnrichmentBases.get(0));
            }
            catch (RuntimeException e) {
                LOGGER.warn("Unable to retrieve entity from entityAbout", (Throwable)e);
            }
        }
        return result;
    }

    public <T extends ReferenceTerm> Map<T, List<EnrichmentBase>> resolveByUri(Set<T> referenceTerms) {
        HashMap<ReferenceTerm, List<EnrichmentBase>> result = new HashMap<ReferenceTerm, List<EnrichmentBase>>();
        for (ReferenceTerm referenceTerm : referenceTerms) {
            try {
                Set entityTypes = referenceTerm.getCandidateTypes();
                List<EnrichmentBase> foundEnrichmentBases = this.getEnrichmentBases(referenceTerm, entityTypes);
                if (!CollectionUtils.isNotEmpty(foundEnrichmentBases)) continue;
                result.put(referenceTerm, foundEnrichmentBases);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Unable to retrieve entity from id", (Throwable)e);
            }
        }
        return result;
    }

    private <T extends ReferenceTerm> List<EnrichmentBase> getEnrichmentBases(T referenceTerm, Set<EntityType> entityTypes) {
        ArrayList<EnrichmentBase> foundEnrichmentBases;
        if (CollectionUtils.isEmpty(entityTypes)) {
            foundEnrichmentBases = this.searchBasesFirstAboutThenOwlSameAs(referenceTerm.getReference().toString(), null);
        } else {
            foundEnrichmentBases = new ArrayList();
            for (EntityType entityType : entityTypes) {
                foundEnrichmentBases.addAll(this.searchBasesFirstAboutThenOwlSameAs(referenceTerm.getReference().toString(), entityType));
            }
        }
        return foundEnrichmentBases;
    }

    private <T extends SearchTerm> void findEnrichmentEntitiesBySearchTerm(Map<T, List<EnrichmentBase>> searchTermListMap, T searchTerm) {
        String value = searchTerm.getTextValue().toLowerCase(Locale.US);
        if (!StringUtils.isBlank((String)value)) {
            Set entityTypes = searchTerm.getCandidateTypes();
            String inputValueLanguage = searchTerm.getLanguage();
            String language = inputValueLanguage != null && inputValueLanguage.length() == 3 ? ALL_3CODE_TO_2CODE_LANGUAGES.get(inputValueLanguage) : (inputValueLanguage != null && inputValueLanguage.length() == 2 ? (ALL_2CODE_LANGUAGES.contains(inputValueLanguage) ? inputValueLanguage : null) : null);
            if (CollectionUtils.isEmpty((Collection)entityTypes)) {
                searchTermListMap.put(searchTerm, this.findEnrichmentTerms(null, value, language));
            } else {
                for (EntityType entityType : entityTypes) {
                    searchTermListMap.put(searchTerm, this.findEnrichmentTerms(entityType, value, language));
                }
            }
        }
    }

    private List<EnrichmentBase> findEnrichmentTerms(EntityType entityType, String termLabel, String termLanguage) {
        HashMap<String, List<Pair<String, String>>> fieldNameMap = new HashMap<String, List<Pair<String, String>>>();
        ArrayList<ImmutablePair> labelInfosFields = new ArrayList<ImmutablePair>();
        labelInfosFields.add(new ImmutablePair((Object)"lowerCaseLabel", (Object)termLabel));
        if (StringUtils.isNotBlank((String)termLanguage)) {
            labelInfosFields.add(new ImmutablePair((Object)"lang", (Object)termLanguage));
        }
        ArrayList<ImmutablePair> enrichmentTermFields = new ArrayList<ImmutablePair>();
        if (entityType != null) {
            enrichmentTermFields.add(new ImmutablePair((Object)"entityType", (Object)entityType.name()));
        }
        fieldNameMap.put("labelInfos", labelInfosFields);
        fieldNameMap.put(null, enrichmentTermFields);
        List<EnrichmentTerm> enrichmentTerms = this.enrichmentDao.getAllEnrichmentTermsByFields(fieldNameMap);
        List<EnrichmentTerm> parentEnrichmentTerms = enrichmentTerms.stream().map(this::findParentEntities).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<EnrichmentBase> enrichmentBases = new ArrayList<EnrichmentBase>();
        enrichmentBases.addAll(Converter.convert(enrichmentTerms));
        enrichmentBases.addAll(Converter.convert(parentEnrichmentTerms));
        return enrichmentBases;
    }

    private List<EnrichmentTerm> findParentEntities(EnrichmentTerm enrichmentTerm) {
        EnrichmentTerm currentEnrichmentTerm;
        HashSet<String> parentAbouts = new HashSet<String>();
        ArrayList<EnrichmentTerm> parentEntities = new ArrayList<EnrichmentTerm>();
        Predicate<String> isTimespanVeryBroad = parent -> enrichmentTerm.getEntityType() == EntityType.TIMESPAN && PATTERN_MATCHING_VERY_BROAD_TIMESPANS.matcher((CharSequence)parent).matches();
        String parentAbout = enrichmentTerm.getEnrichmentEntity().getIsPartOf();
        while (StringUtils.isNotBlank((String)parentAbout) && !isTimespanVeryBroad.test(parentAbout) && (currentEnrichmentTerm = (EnrichmentTerm)this.enrichmentDao.getEnrichmentTermByField("enrichmentEntity.about", parentAbout).orElse(null)) != null && parentAbouts.add(parentAbout)) {
            parentEntities.add(currentEnrichmentTerm);
            parentAbout = currentEnrichmentTerm.getEnrichmentEntity().getIsPartOf();
        }
        return parentEntities;
    }

    private List<EnrichmentBase> searchBasesFirstAboutThenOwlSameAs(String reference, EntityType entityType) {
        ImmutablePair parameterAbout = new ImmutablePair((Object)"enrichmentEntity.about", (Object)reference);
        ImmutablePair parameterOwlSameAs = new ImmutablePair((Object)"enrichmentEntity.owlSameAs", (Object)reference);
        ArrayList<Pair<String, String>> parametersAbout = new ArrayList<Pair<String, String>>();
        ArrayList<Pair<String, String>> parametersOwlSameAs = new ArrayList<Pair<String, String>>();
        if (entityType != null) {
            ImmutablePair parameterEntityType = new ImmutablePair((Object)"entityType", (Object)entityType.name());
            parametersAbout.add((Pair<String, String>)parameterEntityType);
            parametersOwlSameAs.add((Pair<String, String>)parameterEntityType);
        }
        parametersAbout.add((Pair<String, String>)parameterAbout);
        List<EnrichmentBase> foundEnrichmentBases = this.getEnrichmentTermsAndConvert(parametersAbout);
        if (CollectionUtils.isEmpty(foundEnrichmentBases)) {
            parametersOwlSameAs.add((Pair<String, String>)parameterOwlSameAs);
            foundEnrichmentBases = this.getEnrichmentTermsAndConvert(parametersOwlSameAs);
        }
        return foundEnrichmentBases;
    }

    private List<EnrichmentBase> getEnrichmentTermsAndConvert(List<Pair<String, String>> fieldNamesAndValues) {
        List<EnrichmentTerm> enrichmentTerms = this.getEnrichmentTerms(fieldNamesAndValues);
        return Converter.convert(enrichmentTerms);
    }

    private List<EnrichmentTerm> getEnrichmentTerms(List<Pair<String, String>> fieldNamesAndValues) {
        HashMap<String, List<Pair<String, String>>> fieldNameMap = new HashMap<String, List<Pair<String, String>>>();
        fieldNameMap.put(null, fieldNamesAndValues);
        return this.enrichmentDao.getAllEnrichmentTermsByFields(fieldNameMap);
    }

    public OrganizationEnrichmentEntity saveOrganization(OrganizationEnrichmentEntity organizationEnrichmentEntity, Date created, Date updated) {
        EnrichmentTerm enrichmentTerm = EntityConverterUtils.organizationImplToEnrichmentTerm(organizationEnrichmentEntity, created, updated);
        Optional<ObjectId> objectId = this.enrichmentDao.getEnrichmentTermObjectIdByField("enrichmentEntity.about", organizationEnrichmentEntity.getAbout());
        objectId.ifPresent(arg_0 -> ((EnrichmentTerm)enrichmentTerm).setId(arg_0));
        String id = this.enrichmentDao.saveEnrichmentTerm(enrichmentTerm);
        return this.enrichmentDao.getEnrichmentTermByField("_id", id).map(EnrichmentTerm::getEnrichmentEntity).map(OrganizationEnrichmentEntity.class::cast).orElse(null);
    }

    public List<String> findExistingOrganizations(List<String> organizationIds) {
        ArrayList<String> existingOrganizationIds = new ArrayList<String>();
        for (String id : organizationIds) {
            Optional<OrganizationEnrichmentEntity> organization = this.getOrganizationByUri(id);
            organization.ifPresent(value -> existingOrganizationIds.add(value.getAbout()));
        }
        return existingOrganizationIds;
    }

    public Optional<OrganizationEnrichmentEntity> getOrganizationByUri(String uri) {
        List<EnrichmentTerm> enrichmentTerm = this.getEnrichmentTerms(Collections.singletonList(new ImmutablePair((Object)"enrichmentEntity.about", (Object)uri)));
        return enrichmentTerm.stream().findFirst().map(EnrichmentTerm::getEnrichmentEntity).map(OrganizationEnrichmentEntity.class::cast);
    }

    public void deleteOrganizations(List<String> organizationIds) {
        this.enrichmentDao.deleteEnrichmentTerms(EntityType.ORGANIZATION, organizationIds);
    }

    public void deleteOrganization(String organizationId) {
        this.deleteOrganizations(Collections.singletonList(organizationId));
    }

    public Date getDateOfLastUpdatedOrganization() {
        return this.enrichmentDao.getDateOfLastUpdatedEnrichmentTerm(EntityType.ORGANIZATION);
    }

    static {
        PATTERN_MATCHING_VERY_BROAD_TIMESPANS = Pattern.compile("http://semium.org/time/(ChronologicalPeriod$|Time$|(AD|BC)[1-9]x{3}$)");
        HashSet all2CodeLanguages = new HashSet();
        HashMap all3CodeLanguages = new HashMap();
        Arrays.stream(Locale.getISOLanguages()).map(Locale::new).forEach(locale -> {
            all2CodeLanguages.add(locale.getLanguage());
            all3CodeLanguages.put(locale.getISO3Language(), locale.getLanguage());
        });
        ALL_2CODE_LANGUAGES = Collections.unmodifiableSet(all2CodeLanguages);
        ALL_3CODE_TO_2CODE_LANGUAGES = Collections.unmodifiableMap(all3CodeLanguages);
    }
}

