/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import com.zoho.crm.library.crud.ZCRMRecord;
import eu.europeana.corelib.definitions.edm.entity.Address;
import eu.europeana.corelib.solr.entity.AddressImpl;
import eu.europeana.corelib.solr.entity.OrganizationImpl;
import eu.europeana.enrichment.api.external.model.TextProperty;
import eu.europeana.enrichment.api.external.model.WebResource;
import eu.europeana.enrichment.internal.model.AbstractEnrichmentEntity;
import eu.europeana.enrichment.internal.model.EnrichmentTerm;
import eu.europeana.enrichment.internal.model.OrganizationEnrichmentEntity;
import eu.europeana.enrichment.utils.EntityType;
import eu.europeana.metis.zoho.ZohoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class EntityConverterUtils {
    public static final String URL_ORGANIZATION_PREFFIX = "http://data.europeana.eu/organization/";
    private static final String UNDEFINED_LANGUAGE_KEY = "def";
    private static final int LANGUAGE_CODE_LENGTH = 2;
    private static final int MAX_ALTERNATIVES = 5;
    private static final int MAX_LANG_ALTERNATIVES = 5;
    private static final int MAX_SAME_AS = 3;

    public Map<String, List<String>> createMapWithLists(String key, String value) {
        return value == null ? null : Collections.singletonMap(key, Collections.singletonList(value));
    }

    public static Map<String, String> createMap(String key, String value) {
        return value == null ? null : Collections.singletonMap(key, value);
    }

    static List<String> createList(String value) {
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    public Map<String, List<String>> createMapWithLists(List<String> keys, List<String> values) {
        if (CollectionUtils.isEmpty(keys)) {
            return null;
        }
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            resMap.put(EntityConverterUtils.toIsoLanguage(keys.get(i)), EntityConverterUtils.createList(values.get(i)));
        }
        return resMap;
    }

    public static Map<String, List<String>> createMapWithListsFromTextPropertyListMerging(List<? extends TextProperty> textPropertyList) {
        return EntityConverterUtils.createMapWithListsFromTextPropertyList(textPropertyList, true);
    }

    public static Map<String, List<String>> createMapWithListsFromTextPropertyListNonMerging(List<? extends TextProperty> textPropertyList) {
        return EntityConverterUtils.createMapWithListsFromTextPropertyList(textPropertyList, false);
    }

    private static Map<String, List<String>> createMapWithListsFromTextPropertyList(List<? extends TextProperty> textPropertyList, boolean mergeLists) {
        if (textPropertyList == null) {
            return null;
        }
        BinaryOperator mergeOperator = mergeLists ? EntityConverterUtils::mergeStringLists : (list1, list2) -> list1;
        return textPropertyList.stream().collect(Collectors.toMap(property -> EntityConverterUtils.toIsoLanguage(property.getKey()), property -> EntityConverterUtils.createList(property.getValue()), mergeOperator));
    }

    public static Map<String, String> createMapFromTextPropertyList(List<? extends TextProperty> textPropertyList) {
        return textPropertyList == null ? null : textPropertyList.stream().collect(Collectors.toMap(property -> EntityConverterUtils.toIsoLanguage(property.getKey()), TextProperty::getValue, (value1, value2) -> value1));
    }

    public static String[] createStringArrayFromPartList(List<? extends WebResource> resources) {
        return resources == null ? new String[]{} : (String[])resources.stream().map(WebResource::getResourceUri).toArray(String[]::new);
    }

    public Map<String, List<String>> createLanguageMapOfStringList(String language, String value) {
        return value == null ? null : Collections.singletonMap(EntityConverterUtils.toIsoLanguage(language), EntityConverterUtils.createList(value));
    }

    public Map<String, List<String>> createLanguageMapOfStringList(String language, List<String> value) {
        return value == null ? null : Collections.singletonMap(EntityConverterUtils.toIsoLanguage(language), value);
    }

    String toEdmCountry(String organizationCountry) {
        if (StringUtils.isBlank((CharSequence)organizationCountry)) {
            return null;
        }
        String isoCode = null;
        int commaSeparatorPos = organizationCountry.indexOf(44);
        if (commaSeparatorPos > 0) {
            isoCode = organizationCountry.substring(commaSeparatorPos + 1).trim();
        }
        return isoCode;
    }

    private static String toIsoLanguage(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return UNDEFINED_LANGUAGE_KEY;
        }
        return language.substring(0, 2).toLowerCase(Locale.US);
    }

    public static Map<String, List<String>> mergeMapsWithLists(Map<String, List<String>> baseMap, Map<String, List<String>> addMap) {
        if (baseMap == null && addMap == null) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (baseMap != null) {
            result.putAll(baseMap);
        }
        if (addMap != null) {
            addMap.forEach((key, value) -> result.merge((String)key, new ArrayList(value), EntityConverterUtils::mergeStringLists));
        }
        return result.isEmpty() ? null : result;
    }

    public static Map<String, List<String>> mergeMapsWithSingletonLists(Map<String, List<String>> baseMap, Map<String, List<String>> addMap, Map<String, List<String>> notMergedMap) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(baseMap);
        for (Map.Entry<String, List<String>> entry : addMap.entrySet()) {
            String key = entry.getKey();
            if (result.containsKey(key)) {
                List unmergedValues = entry.getValue().stream().distinct().filter(value -> !((List)result.get(key)).contains(value)).collect(Collectors.toList());
                if (unmergedValues.isEmpty()) continue;
                notMergedMap.merge(key, unmergedValues, EntityConverterUtils::mergeStringLists);
                continue;
            }
            result.put(key, new ArrayList(entry.getValue()));
        }
        return result;
    }

    public static List<String> mergeStringLists(List<String> baseList, List<String> addList) {
        HashSet<String> result = new HashSet<String>();
        if (baseList != null) {
            result.addAll(baseList);
        }
        if (addList != null) {
            result.addAll(addList);
        }
        return result.isEmpty() ? null : new ArrayList(result);
    }

    public static String[] mergeStringArrays(String[] base, String[] add) {
        List<String> baseList = base == null ? Collections.emptyList() : Arrays.asList(base);
        List<String> addList = add == null ? Collections.emptyList() : Arrays.asList(add);
        List<String> mergedList = EntityConverterUtils.mergeStringLists(baseList, addList);
        return mergedList == null ? null : mergedList.toArray(new String[0]);
    }

    public static void mergeAddress(OrganizationImpl baseOrganization, OrganizationImpl addOrganization) {
        if (addOrganization.getAddress() == null) {
            return;
        }
        if (baseOrganization.getAddress() == null) {
            baseOrganization.setAddress((Address)new AddressImpl());
        }
        Address baseAddress = baseOrganization.getAddress();
        Address addAddress = addOrganization.getAddress();
        if (StringUtils.isEmpty((CharSequence)baseAddress.getVcardCountryName()) && StringUtils.isNotEmpty((CharSequence)addAddress.getVcardCountryName())) {
            baseAddress.setVcardCountryName(addAddress.getVcardCountryName());
        }
        if (StringUtils.isEmpty((CharSequence)baseAddress.getVcardHasGeo())) {
            baseAddress.setVcardHasGeo(addAddress.getVcardHasGeo());
        }
    }

    public static EnrichmentTerm organizationImplToEnrichmentTerm(OrganizationEnrichmentEntity organizationEnrichmentEntity, Date created, Date updated) {
        EnrichmentTerm enrichmentTerm = new EnrichmentTerm();
        enrichmentTerm.setEnrichmentEntity((AbstractEnrichmentEntity)organizationEnrichmentEntity);
        enrichmentTerm.setEntityType(EntityType.ORGANIZATION);
        enrichmentTerm.setCreated(Objects.requireNonNullElseGet(created, Date::new));
        enrichmentTerm.setUpdated(updated);
        return enrichmentTerm;
    }

    public List<String> getOrganizationRoles(OrganizationImpl organization) {
        return (List)organization.getEdmEuropeanaRole().get(Locale.ENGLISH.toString());
    }

    public OrganizationImpl toEdmOrganization(ZCRMRecord zohoOrganization) {
        OrganizationImpl org = new OrganizationImpl();
        HashMap zohoOrganizationFields = zohoOrganization.getData();
        org.setAbout(URL_ORGANIZATION_PREFFIX + zohoOrganization.getEntityId());
        org.setDcIdentifier(this.createMapWithLists(UNDEFINED_LANGUAGE_KEY, Long.toString(zohoOrganization.getEntityId())));
        String isoLanguage = EntityConverterUtils.toIsoLanguage(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Lang_Organisation_Name")));
        org.setPrefLabel(this.createMapWithLists(isoLanguage, ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Account_Name"))));
        org.setAltLabel(this.createMapWithLists(this.getFieldArray(zohoOrganizationFields, "Lang_Alternative", 5), this.getFieldArray(zohoOrganizationFields, "Alternative", 5)));
        org.setEdmAcronym(this.createLanguageMapOfStringList(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Lang_Acronym")), ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Acronym"))));
        org.setFoafLogo(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Logo_link_to_WikimediaCommons")));
        org.setFoafHomepage(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Website")));
        List organizationRoleStringList = (List)zohoOrganizationFields.get("Organisation_Role2");
        if (organizationRoleStringList != null) {
            org.setEdmEuropeanaRole(this.createLanguageMapOfStringList(Locale.ENGLISH.getLanguage(), organizationRoleStringList));
        }
        List organizationDomainStringList = (List)zohoOrganizationFields.get("Domain2");
        org.setEdmOrganizationDomain(EntityConverterUtils.createMap(Locale.ENGLISH.getLanguage(), CollectionUtils.isEmpty((Collection)organizationDomainStringList) ? null : (String)organizationDomainStringList.get(0)));
        org.setEdmOrganizationSector(EntityConverterUtils.createMap(Locale.ENGLISH.getLanguage(), ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Sector"))));
        org.setEdmOrganizationScope(EntityConverterUtils.createMap(Locale.ENGLISH.getLanguage(), ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Scope"))));
        List geographicLevelList = (List)zohoOrganizationFields.get("Geographic_Level");
        org.setEdmGeorgraphicLevel(EntityConverterUtils.createMap(Locale.ENGLISH.getLanguage(), CollectionUtils.isEmpty((Collection)geographicLevelList) ? null : (String)geographicLevelList.get(0)));
        String organizationCountry = this.toEdmCountry(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Country1")));
        org.setEdmCountry(EntityConverterUtils.createMap(Locale.ENGLISH.getLanguage(), organizationCountry));
        List<String> sameAsList = this.getFieldArray(zohoOrganizationFields, "SameAs", 3);
        if (!CollectionUtils.isEmpty(sameAsList)) {
            org.setOwlSameAs(sameAsList.toArray(new String[0]));
        }
        AddressImpl address = new AddressImpl();
        address.setAbout(org.getAbout() + "#address");
        address.setVcardStreetAddress(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Street")));
        address.setVcardLocality(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("City")));
        address.setVcardCountryName(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("Country")));
        address.setVcardPostalCode(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("ZIP_code")));
        address.setVcardPostOfficeBox(ZohoUtils.stringFieldSupplier(zohoOrganizationFields.get("PO_box")));
        org.setAddress((Address)address);
        return org;
    }

    private List<String> getFieldArray(HashMap<String, Object> zohoOrganizationFields, String fieldBaseName, int size) {
        ArrayList<String> res = new ArrayList<String>(size);
        String fieldName = fieldBaseName + "_%d";
        for (int i = 0; i < size; ++i) {
            String fieldValue = ZohoUtils.stringFieldSupplier((Object)zohoOrganizationFields.get(String.format(fieldName, i)));
            if (!StringUtils.isNotBlank((CharSequence)fieldValue)) continue;
            res.add(fieldValue);
        }
        return res;
    }
}

