/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.enrichment.api.external.ReferenceValue;
import eu.europeana.enrichment.api.external.SearchValue;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.EnrichmentResultBaseWrapper;
import eu.europeana.enrichment.api.internal.ReferenceTermImpl;
import eu.europeana.enrichment.api.internal.SearchTermImpl;
import eu.europeana.enrichment.internal.model.OrganizationEnrichmentEntity;
import eu.europeana.enrichment.service.PersistentEntityResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnrichmentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentService.class);
    private final PersistentEntityResolver persistentEntityResolver;

    @Autowired
    public EnrichmentService(PersistentEntityResolver persistentEntityResolver) {
        this.persistentEntityResolver = persistentEntityResolver;
    }

    public List<EnrichmentResultBaseWrapper> enrichByEnrichmentSearchValues(List<SearchValue> searchValues) {
        List orderedSearchTerms = searchValues.stream().map(search -> new SearchTermImpl(search.getValue(), search.getLanguage(), Set.copyOf(search.getEntityTypes()))).collect(Collectors.toList());
        Map result = this.persistentEntityResolver.resolveByText(new HashSet(orderedSearchTerms));
        return orderedSearchTerms.stream().map(result::get).map(EnrichmentResultBaseWrapper::new).collect(Collectors.toList());
    }

    public List<EnrichmentBase> enrichByEquivalenceValues(ReferenceValue referenceValue) {
        try {
            ReferenceTermImpl referenceTerm = new ReferenceTermImpl(new URL(referenceValue.getReference()), Set.copyOf(referenceValue.getEntityTypes()));
            return this.persistentEntityResolver.resolveByUri(Set.of(referenceTerm)).getOrDefault(referenceTerm, Collections.emptyList());
        }
        catch (MalformedURLException e) {
            LOGGER.debug("There was a problem converting the input to ReferenceTermType");
            throw new BadRequestException("The input values are invalid", (Throwable)e);
        }
    }

    public EnrichmentBase enrichById(String entityAbout) {
        try {
            ReferenceTermImpl referenceTerm = new ReferenceTermImpl(new URL(entityAbout), new HashSet());
            return this.persistentEntityResolver.resolveById(Set.of(referenceTerm)).get(referenceTerm);
        }
        catch (MalformedURLException e) {
            LOGGER.debug("There was a problem converting the input to ReferenceTermType");
            throw new BadRequestException("The input values are invalid", (Throwable)e);
        }
    }

    public OrganizationEnrichmentEntity saveOrganization(OrganizationEnrichmentEntity organizationEnrichmentEntity, Date created, Date updated) {
        return this.persistentEntityResolver.saveOrganization(organizationEnrichmentEntity, created, updated);
    }

    public List<String> findExistingOrganizations(List<String> organizationIds) {
        return this.persistentEntityResolver.findExistingOrganizations(organizationIds);
    }

    public Optional<OrganizationEnrichmentEntity> getOrganizationByUri(String uri) {
        return this.persistentEntityResolver.getOrganizationByUri(uri);
    }

    public void deleteOrganizations(List<String> organizationIds) {
        this.persistentEntityResolver.deleteOrganizations(organizationIds);
    }

    public void deleteOrganization(String organizationId) {
        this.persistentEntityResolver.deleteOrganization(organizationId);
    }

    public Date getDateOfLastUpdatedOrganization() {
        return this.persistentEntityResolver.getDateOfLastUpdatedOrganization();
    }
}

