/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.enrichment.api.external.model.Agent;
import eu.europeana.enrichment.api.external.model.Concept;
import eu.europeana.enrichment.api.external.model.EnrichmentBase;
import eu.europeana.enrichment.api.external.model.Label;
import eu.europeana.enrichment.api.external.model.LabelResource;
import eu.europeana.enrichment.api.external.model.Part;
import eu.europeana.enrichment.api.external.model.Place;
import eu.europeana.enrichment.api.external.model.Resource;
import eu.europeana.enrichment.api.external.model.Timespan;
import eu.europeana.enrichment.internal.model.AgentEnrichmentEntity;
import eu.europeana.enrichment.internal.model.ConceptEnrichmentEntity;
import eu.europeana.enrichment.internal.model.EnrichmentTerm;
import eu.europeana.enrichment.internal.model.PlaceEnrichmentEntity;
import eu.europeana.enrichment.internal.model.TimespanEnrichmentEntity;
import eu.europeana.enrichment.utils.EntityType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public final class Converter {
    private Converter() {
    }

    public static List<EnrichmentBase> convert(List<EnrichmentTerm> enrichmentTerms) {
        return enrichmentTerms.stream().map(Converter::convert).collect(Collectors.toList());
    }

    public static EnrichmentBase convert(EnrichmentTerm enrichmentTerm) {
        Agent result;
        EntityType entityType = enrichmentTerm.getEntityType();
        if (entityType == null) {
            return null;
        }
        switch (entityType) {
            case AGENT: {
                result = Converter.convertAgent((AgentEnrichmentEntity)enrichmentTerm.getEnrichmentEntity());
                break;
            }
            case CONCEPT: {
                result = Converter.convertConcept((ConceptEnrichmentEntity)enrichmentTerm.getEnrichmentEntity());
                break;
            }
            case PLACE: {
                result = Converter.convertPlace((PlaceEnrichmentEntity)enrichmentTerm.getEnrichmentEntity());
                break;
            }
            case TIMESPAN: {
                result = Converter.convertTimespan((TimespanEnrichmentEntity)enrichmentTerm.getEnrichmentEntity());
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static Timespan convertTimespan(TimespanEnrichmentEntity timespanEnrichmentEntity) {
        Timespan output = new Timespan();
        output.setAbout(timespanEnrichmentEntity.getAbout());
        output.setPrefLabelList(Converter.convert(timespanEnrichmentEntity.getPrefLabel()));
        output.setAltLabelList(Converter.convert(timespanEnrichmentEntity.getAltLabel()));
        output.setBeginList(Converter.convert(timespanEnrichmentEntity.getBegin()));
        output.setEndList(Converter.convert(timespanEnrichmentEntity.getEnd()));
        output.setHasPartsList(Converter.convertPart(timespanEnrichmentEntity.getDctermsHasPart()));
        output.setHiddenLabel(Converter.convert(timespanEnrichmentEntity.getHiddenLabel()));
        output.setNotes(Converter.convert(timespanEnrichmentEntity.getNote()));
        output.setSameAs(Converter.convertToPartsList(timespanEnrichmentEntity.getOwlSameAs()));
        if (StringUtils.isNotBlank((String)timespanEnrichmentEntity.getIsPartOf())) {
            output.setIsPartOf(new Part(timespanEnrichmentEntity.getIsPartOf()));
        }
        if (StringUtils.isNotBlank((String)timespanEnrichmentEntity.getIsNextInSequence())) {
            output.setIsNextInSequence(new Part(timespanEnrichmentEntity.getIsNextInSequence()));
        }
        return output;
    }

    private static Concept convertConcept(ConceptEnrichmentEntity conceptEnrichmentEntity) {
        Concept output = new Concept();
        output.setAbout(conceptEnrichmentEntity.getAbout());
        output.setPrefLabelList(Converter.convert(conceptEnrichmentEntity.getPrefLabel()));
        output.setAltLabelList(Converter.convert(conceptEnrichmentEntity.getAltLabel()));
        output.setHiddenLabel(Converter.convert(conceptEnrichmentEntity.getHiddenLabel()));
        output.setNotation(Converter.convert(conceptEnrichmentEntity.getNotation()));
        output.setNotes(Converter.convert(conceptEnrichmentEntity.getNote()));
        output.setBroader(Converter.convertToResourceList(conceptEnrichmentEntity.getBroader()));
        output.setBroadMatch(Converter.convertToResourceList(conceptEnrichmentEntity.getBroadMatch()));
        output.setCloseMatch(Converter.convertToResourceList(conceptEnrichmentEntity.getCloseMatch()));
        output.setExactMatch(Converter.convertToResourceList(conceptEnrichmentEntity.getExactMatch()));
        output.setInScheme(Converter.convertToResourceList(conceptEnrichmentEntity.getInScheme()));
        output.setNarrower(Converter.convertToResourceList(conceptEnrichmentEntity.getNarrower()));
        output.setNarrowMatch(Converter.convertToResourceList(conceptEnrichmentEntity.getNarrowMatch()));
        output.setRelated(Converter.convertToResourceList(conceptEnrichmentEntity.getRelated()));
        output.setRelatedMatch(Converter.convertToResourceList(conceptEnrichmentEntity.getRelatedMatch()));
        return output;
    }

    private static Place convertPlace(PlaceEnrichmentEntity placeEnrichmentEntity) {
        Place output = new Place();
        output.setAbout(placeEnrichmentEntity.getAbout());
        output.setPrefLabelList(Converter.convert(placeEnrichmentEntity.getPrefLabel()));
        output.setAltLabelList(Converter.convert(placeEnrichmentEntity.getAltLabel()));
        output.setHasPartsList(Converter.convertPart(placeEnrichmentEntity.getDcTermsHasPart()));
        output.setNotes(Converter.convert(placeEnrichmentEntity.getNote()));
        output.setSameAs(Converter.convertToPartsList(placeEnrichmentEntity.getOwlSameAs()));
        if (StringUtils.isNotBlank((String)placeEnrichmentEntity.getIsPartOf())) {
            output.setIsPartOf(new Part(placeEnrichmentEntity.getIsPartOf()));
        }
        if (placeEnrichmentEntity.getLatitude() != null && placeEnrichmentEntity.getLatitude().floatValue() != 0.0f && placeEnrichmentEntity.getLongitude() != null && placeEnrichmentEntity.getLongitude().floatValue() != 0.0f) {
            output.setLat(placeEnrichmentEntity.getLatitude().toString());
            output.setLon(placeEnrichmentEntity.getLongitude().toString());
        }
        if (placeEnrichmentEntity.getAltitude() != null && placeEnrichmentEntity.getAltitude().floatValue() != 0.0f) {
            output.setAlt(placeEnrichmentEntity.getAltitude().toString());
        }
        return output;
    }

    private static Agent convertAgent(AgentEnrichmentEntity agentEntityEnrichment) {
        Agent output = new Agent();
        output.setAbout(agentEntityEnrichment.getAbout());
        output.setPrefLabelList(Converter.convert(agentEntityEnrichment.getPrefLabel()));
        output.setAltLabelList(Converter.convert(agentEntityEnrichment.getAltLabel()));
        output.setHiddenLabel(Converter.convert(agentEntityEnrichment.getHiddenLabel()));
        output.setFoafName(Converter.convert(agentEntityEnrichment.getFoafName()));
        output.setNotes(Converter.convert(agentEntityEnrichment.getNote()));
        output.setBeginList(Converter.convert(agentEntityEnrichment.getBegin()));
        output.setEndList(Converter.convert(agentEntityEnrichment.getEnd()));
        output.setIdentifier(Converter.convert(agentEntityEnrichment.getDcIdentifier()));
        output.setHasMet(Converter.convert(agentEntityEnrichment.getEdmHasMet()));
        output.setBiographicaInformation(Converter.convert(agentEntityEnrichment.getRdaGr2BiographicalInformation()));
        output.setPlaceOfBirth(Converter.convertResourceOrLiteral(agentEntityEnrichment.getRdaGr2PlaceOfBirth()));
        output.setPlaceOfDeath(Converter.convertResourceOrLiteral(agentEntityEnrichment.getRdaGr2PlaceOfDeath()));
        output.setDateOfBirth(Converter.convert(agentEntityEnrichment.getRdaGr2DateOfBirth()));
        output.setDateOfDeath(Converter.convert(agentEntityEnrichment.getRdaGr2DateOfDeath()));
        output.setDateOfEstablishment(Converter.convert(agentEntityEnrichment.getRdaGr2DateOfEstablishment()));
        output.setDateOfTermination(Converter.convert(agentEntityEnrichment.getRdaGr2DateOfTermination()));
        output.setGender(Converter.convert(agentEntityEnrichment.getRdaGr2Gender()));
        output.setDate(Converter.convertResourceOrLiteral(agentEntityEnrichment.getDcDate()));
        output.setProfessionOrOccupation(Converter.convertResourceOrLiteral(agentEntityEnrichment.getRdaGr2ProfessionOrOccupation()));
        output.setWasPresentAt(Converter.convertToResourceList(agentEntityEnrichment.getEdmWasPresentAt()));
        output.setSameAs(Converter.convertToPartsList(agentEntityEnrichment.getOwlSameAs()));
        return output;
    }

    private static List<Label> convert(Map<String, List<String>> map) {
        ArrayList<Label> labels = new ArrayList<Label>();
        if (map == null) {
            return labels;
        }
        map.forEach((key, entry) -> entry.stream().map(value -> new Label(key, value)).forEach(labels::add));
        return labels;
    }

    private static List<Part> convertPart(Map<String, List<String>> map) {
        ArrayList<Part> parts = new ArrayList<Part>();
        if (map == null) {
            return parts;
        }
        map.forEach((key, entry) -> entry.stream().map(Part::new).forEach(parts::add));
        return parts;
    }

    private static List<LabelResource> convertResourceOrLiteral(Map<String, List<String>> map) {
        ArrayList<LabelResource> parts = new ArrayList<LabelResource>();
        if (map == null) {
            return parts;
        }
        map.forEach((key, entry) -> entry.stream().map(value -> Converter.isUri(key) ? new LabelResource(key) : new LabelResource(key, value)).forEach(parts::add));
        return parts;
    }

    private static List<Resource> convertToResourceList(String[] resources) {
        if (resources == null) {
            return new ArrayList<Resource>();
        }
        return Arrays.stream(resources).map(Resource::new).collect(Collectors.toList());
    }

    private static List<Part> convertToPartsList(List<String> resources) {
        if (resources == null) {
            return new ArrayList<Part>();
        }
        return resources.stream().map(Part::new).collect(Collectors.toList());
    }

    private static boolean isUri(String str) {
        return str.startsWith("http://");
    }
}

