/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import eu.europeana.corelib.solr.entity.ContextualClassImpl;
import eu.europeana.enrichment.api.internal.AgentTermList;
import eu.europeana.enrichment.api.internal.ConceptTermList;
import eu.europeana.enrichment.api.internal.MongoTerm;
import eu.europeana.enrichment.api.internal.MongoTermList;
import eu.europeana.enrichment.api.internal.OrganizationTermList;
import eu.europeana.enrichment.api.internal.PlaceTermList;
import eu.europeana.enrichment.api.internal.TimespanTermList;
import eu.europeana.enrichment.utils.EntityClass;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.mongojack.DBCursor;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichmentEntityDao
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentEntityDao.class);
    private static final String ENTITY_TYPE_PROPERTY = "entityType";
    private static final String PLACE_TYPE = "PlaceImpl";
    private static final String CONCEPT_TYPE = "ConceptImpl";
    private static final String AGENT_TYPE = "AgentImpl";
    private static final String TIMESPAN_TYPE = "TimespanImpl";
    private static final String ORGANIZATION_TYPE = "OrganizationImpl";
    private static final String AGENT_TABLE = "people";
    private static final String CONCEPT_TABLE = "concept";
    private static final String PLACE_TABLE = "place";
    private static final String TIMESPAN_TABLE = "period";
    private static final String ORGANIZATION_TABLE = "organization";
    private static final String TERMLIST_TABLE = "TermList";
    private static final String UNIQUE_PROPERTY = "unique";
    private static final String TERM_SAME_AS = "owlSameAs";
    private static final String TERM_CODE_URI = "codeUri";
    private static final String TERM_LANG = "lang";
    private static final String TERM_LABEL = "label";
    private static final String TERM_MODIFIED = "modified";
    private final MongoClient mongo;
    private DbAccess dbAccess;

    public EnrichmentEntityDao(String host, int port) {
        this.mongo = new MongoClient(host, port);
    }

    public EnrichmentEntityDao(String connectionUrl) {
        this.mongo = new MongoClient(new MongoClientURI(connectionUrl));
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    private synchronized DbAccess initDbIfNeeded() {
        if (this.dbAccess != null) {
            return this.dbAccess;
        }
        try {
            LOGGER.info("Creating Mongo connection to host {}.", (Object)this.mongo.getAddress());
            DB db = this.mongo.getDB("annocultor_db");
            boolean exist = db.collectionExists(TERMLIST_TABLE);
            JacksonDBCollection cColl = JacksonDBCollection.wrap((DBCollection)db.getCollection(TERMLIST_TABLE), ConceptTermList.class, String.class);
            JacksonDBCollection aColl = JacksonDBCollection.wrap((DBCollection)db.getCollection(TERMLIST_TABLE), AgentTermList.class, String.class);
            JacksonDBCollection tColl = JacksonDBCollection.wrap((DBCollection)db.getCollection(TERMLIST_TABLE), TimespanTermList.class, String.class);
            JacksonDBCollection pColl = JacksonDBCollection.wrap((DBCollection)db.getCollection(TERMLIST_TABLE), PlaceTermList.class, String.class);
            JacksonDBCollection oColl = JacksonDBCollection.wrap((DBCollection)db.getCollection(TERMLIST_TABLE), OrganizationTermList.class, String.class);
            if (!exist) {
                cColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                cColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                cColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                aColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                aColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                aColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                tColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                tColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                tColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                pColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                pColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                pColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                oColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                oColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                oColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
            }
            this.dbAccess = new DbAccess((JacksonDBCollection<ConceptTermList, String>)cColl, (JacksonDBCollection<PlaceTermList, String>)pColl, (JacksonDBCollection<TimespanTermList, String>)tColl, (JacksonDBCollection<AgentTermList, String>)aColl, (JacksonDBCollection<OrganizationTermList, String>)oColl, db);
            return this.dbAccess;
        }
        catch (MongoException e) {
            LOGGER.error("Error accessing mongo", (Throwable)e);
            throw e;
        }
    }

    public List<String> delete(List<String> uris) {
        DbAccess currentDbAccess = this.initDbIfNeeded();
        ArrayList<String> retUris = new ArrayList<String>();
        for (String uri : uris) {
            retUris.add(uri);
            retUris.addAll(EnrichmentEntityDao.deletePlaces(currentDbAccess, uri));
            retUris.addAll(EnrichmentEntityDao.deleteConcepts(currentDbAccess, uri));
            retUris.addAll(EnrichmentEntityDao.deleteAgents(currentDbAccess, uri));
            retUris.addAll(EnrichmentEntityDao.deleteTimespan(currentDbAccess, uri));
            retUris.addAll(EnrichmentEntityDao.deleteOrganizations(currentDbAccess, uri));
        }
        return retUris;
    }

    private static List<String> deleteTimespan(DbAccess dbAccess, String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        dbAccess.tColl.remove(((DBCursor)dbAccess.tColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection termT = JacksonDBCollection.wrap((DBCollection)dbAccess.db.getCollection(TIMESPAN_TABLE), MongoTerm.class, String.class);
        termT.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termT.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        termT.remove(((DBCursor)termT.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        DBCursor objT = dbAccess.tColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)TIMESPAN_TYPE));
        if (objT.hasNext()) {
            String origT = ((TimespanTermList)objT.next()).getCodeUri();
            retUris.add(origT);
            dbAccess.tColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origT));
            termT.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origT));
        }
        return retUris;
    }

    private static List<String> deleteAgents(DbAccess dbAccess, String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        dbAccess.aColl.remove(((DBCursor)dbAccess.aColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection termA = JacksonDBCollection.wrap((DBCollection)dbAccess.db.getCollection(AGENT_TABLE), MongoTerm.class, String.class);
        termA.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termA.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        termA.remove(((DBCursor)termA.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        DBCursor objA = dbAccess.aColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)AGENT_TYPE));
        if (objA.hasNext()) {
            String origA = ((AgentTermList)objA.next()).getCodeUri();
            retUris.add(origA);
            dbAccess.aColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origA));
            termA.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origA));
        }
        return retUris;
    }

    public void deleteOrganizations(String uri) {
        DbAccess currentDbAccess = this.initDbIfNeeded();
        EnrichmentEntityDao.deleteOrganizations(currentDbAccess, uri);
    }

    private static List<String> deleteOrganizations(DbAccess dbAccess, String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        dbAccess.oColl.remove(((DBCursor)dbAccess.oColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection<MongoTerm, String> termA = EnrichmentEntityDao.deleteOrganizationTerms(dbAccess, uri);
        termA.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termA.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        DBCursor objA = dbAccess.oColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)ORGANIZATION_TYPE));
        if (objA.hasNext()) {
            String origA = ((OrganizationTermList)objA.next()).getCodeUri();
            retUris.add(origA);
            dbAccess.oColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origA));
            termA.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origA));
        }
        return retUris;
    }

    public void deleteOrganizationTerms(String uri) {
        DbAccess currentDbAccess = this.initDbIfNeeded();
        EnrichmentEntityDao.deleteOrganizationTerms(currentDbAccess, uri);
    }

    private static JacksonDBCollection<MongoTerm, String> deleteOrganizationTerms(DbAccess dbAccess, String uri) {
        JacksonDBCollection termA = JacksonDBCollection.wrap((DBCollection)dbAccess.db.getCollection(ORGANIZATION_TABLE), MongoTerm.class, String.class);
        termA.remove(((DBCursor)termA.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        return termA;
    }

    private static List<String> deleteConcepts(DbAccess dbAccess, String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        dbAccess.cColl.remove(((DBCursor)dbAccess.cColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection termC = JacksonDBCollection.wrap((DBCollection)dbAccess.db.getCollection(CONCEPT_TABLE), MongoTerm.class, String.class);
        termC.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termC.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        termC.remove(((DBCursor)termC.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        DBCursor objC = dbAccess.cColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)CONCEPT_TYPE));
        if (objC.hasNext()) {
            String origC = ((ConceptTermList)objC.next()).getCodeUri();
            retUris.add(origC);
            dbAccess.cColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origC));
            termC.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origC));
        }
        return retUris;
    }

    private static List<String> deletePlaces(DbAccess dbAccess, String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        dbAccess.pColl.remove(((DBCursor)dbAccess.pColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection termP = JacksonDBCollection.wrap((DBCollection)dbAccess.db.getCollection(PLACE_TABLE), MongoTerm.class, String.class);
        termP.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termP.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        termP.remove(((DBCursor)termP.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        DBCursor objP = dbAccess.pColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)PLACE_TYPE));
        if (objP.hasNext()) {
            String origP = ((PlaceTermList)objP.next()).getCodeUri();
            retUris.add(origP);
            dbAccess.pColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origP));
            termP.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origP));
        }
        return retUris;
    }

    public MongoTermList<ContextualClassImpl> findByCode(String codeUri, EntityClass entityClass) {
        ConceptTermList result;
        DbAccess currentDbAccess = this.initDbIfNeeded();
        switch (entityClass) {
            case CONCEPT: {
                result = EnrichmentEntityDao.findConceptByCode(currentDbAccess, codeUri);
                break;
            }
            case PLACE: {
                result = EnrichmentEntityDao.findPlaceByCode(currentDbAccess, codeUri);
                break;
            }
            case AGENT: {
                result = EnrichmentEntityDao.findAgentByCode(currentDbAccess, codeUri);
                break;
            }
            case TIMESPAN: {
                result = EnrichmentEntityDao.findTimespanByCode(currentDbAccess, codeUri);
                break;
            }
            case ORGANIZATION: {
                result = EnrichmentEntityDao.findOrganizationByCode(currentDbAccess, codeUri);
                break;
            }
            default: {
                result = null;
            }
        }
        return MongoTermList.cast((MongoTermList)result);
    }

    private static TimespanTermList findTimespanByCode(DbAccess dbAccess, String codeUri) {
        DBCursor curs = (DBCursor)dbAccess.tColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)TIMESPAN_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (TimespanTermList)curs.next();
        }
        return null;
    }

    private static AgentTermList findAgentByCode(DbAccess dbAccess, String codeUri) {
        DBCursor curs = (DBCursor)dbAccess.aColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)AGENT_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (AgentTermList)curs.next();
        }
        return null;
    }

    private static PlaceTermList findPlaceByCode(DbAccess dbAccess, String codeUri) {
        DBCursor curs = (DBCursor)dbAccess.pColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)PLACE_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (PlaceTermList)curs.next();
        }
        return null;
    }

    private static ConceptTermList findConceptByCode(DbAccess dbAccess, String codeUri) {
        DBCursor curs = (DBCursor)dbAccess.cColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)CONCEPT_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (ConceptTermList)curs.next();
        }
        return null;
    }

    private static OrganizationTermList findOrganizationByCode(DbAccess dbAccess, String codeUri) {
        DBCursor curs = (DBCursor)dbAccess.oColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)ORGANIZATION_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (OrganizationTermList)curs.next();
        }
        return null;
    }

    private String getTableName(EntityClass entityClass) {
        String result;
        switch (entityClass) {
            case AGENT: {
                result = AGENT_TABLE;
                break;
            }
            case CONCEPT: {
                result = CONCEPT_TABLE;
                break;
            }
            case PLACE: {
                result = PLACE_TABLE;
                break;
            }
            case TIMESPAN: {
                result = TIMESPAN_TABLE;
                break;
            }
            case ORGANIZATION: {
                result = ORGANIZATION_TABLE;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown entity: " + entityClass);
            }
        }
        return result;
    }

    private static String getTypeName(EntityClass entityClass) {
        if (entityClass != EntityClass.ORGANIZATION) {
            throw new IllegalStateException("Unknown entity: " + entityClass);
        }
        String result = ORGANIZATION_TYPE;
        return result;
    }

    public List<MongoTerm> getAllMongoTerms(EntityClass entityClass) {
        DbAccess currentDbAccess = this.initDbIfNeeded();
        JacksonDBCollection collection = JacksonDBCollection.wrap((DBCollection)currentDbAccess.db.getCollection(this.getTableName(entityClass)), MongoTerm.class, String.class);
        DBCursor curs = collection.find();
        return StreamSupport.stream(curs.spliterator(), false).collect(Collectors.toList());
    }

    public OrganizationTermList storeMongoTermList(MongoTermList<? extends ContextualClassImpl> termList) {
        DbAccess currentDbAccess = this.initDbIfNeeded();
        String type = termList.getEntityType();
        if (ORGANIZATION_TYPE.equals(type)) {
            return EnrichmentEntityDao.saveOrganization(currentDbAccess, (OrganizationTermList)termList);
        }
        throw new IllegalArgumentException("insertion of MongoTermList of type: " + type + " not supported yet!");
    }

    private static OrganizationTermList saveOrganization(DbAccess dbAccess, OrganizationTermList termList) {
        return (OrganizationTermList)dbAccess.oColl.save((Object)termList).getSavedObject();
    }

    public int storeEntityLabels(ContextualClassImpl entity, EntityClass entityClass) {
        DbAccess currentDbAccess = this.initDbIfNeeded();
        String collection = this.getTableName(entityClass);
        JacksonDBCollection termColl = JacksonDBCollection.wrap((DBCollection)currentDbAccess.db.getCollection(collection), MongoTerm.class, String.class);
        List<MongoTerm> terms = EnrichmentEntityDao.createListOfMongoTerms(entity);
        WriteResult res = termColl.insert(terms);
        return res.getN();
    }

    private static List<MongoTerm> createListOfMongoTerms(ContextualClassImpl entity) {
        ArrayList<MongoTerm> terms = new ArrayList<MongoTerm>();
        for (Map.Entry prefLabel : entity.getPrefLabel().entrySet()) {
            for (String label : (List)prefLabel.getValue()) {
                MongoTerm term = new MongoTerm();
                term.setCodeUri(entity.getAbout());
                term.setLabel(label.toLowerCase());
                String lang = (String)prefLabel.getKey();
                term.setOriginalLabel(label);
                term.setLang(lang);
                terms.add(term);
            }
        }
        return terms;
    }

    public Date getLastModifiedDate(EntityClass entityClass) {
        DbAccess currentDbAccess = this.initDbIfNeeded();
        DBCursor cursor = currentDbAccess.oColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)EnrichmentEntityDao.getTypeName(entityClass))).sort((DBObject)DBSort.desc((String)TERM_MODIFIED)).limit(1);
        if (cursor.size() == 0) {
            return null;
        }
        OrganizationTermList lastModifiedOrg = (OrganizationTermList)cursor.next();
        return lastModifiedOrg.getModified();
    }

    private static class DbAccess {
        protected final JacksonDBCollection<ConceptTermList, String> cColl;
        protected final JacksonDBCollection<PlaceTermList, String> pColl;
        protected final JacksonDBCollection<TimespanTermList, String> tColl;
        protected final JacksonDBCollection<AgentTermList, String> aColl;
        protected final JacksonDBCollection<OrganizationTermList, String> oColl;
        protected final DB db;

        public DbAccess(JacksonDBCollection<ConceptTermList, String> cColl, JacksonDBCollection<PlaceTermList, String> pColl, JacksonDBCollection<TimespanTermList, String> tColl, JacksonDBCollection<AgentTermList, String> aColl, JacksonDBCollection<OrganizationTermList, String> oColl, DB db) {
            this.cColl = cColl;
            this.pColl = pColl;
            this.tColl = tColl;
            this.aColl = aColl;
            this.oColl = oColl;
            this.db = db;
        }
    }
}

