/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.corelib.solr.entity.ContextualClassImpl;
import eu.europeana.enrichment.api.external.EntityWrapper;
import eu.europeana.enrichment.api.external.ObjectIdSerializer;
import eu.europeana.enrichment.api.internal.MongoTerm;
import eu.europeana.enrichment.api.internal.MongoTermList;
import eu.europeana.enrichment.utils.EnrichmentEntityDao;
import eu.europeana.enrichment.utils.EntityClass;
import eu.europeana.enrichment.utils.InputValue;
import eu.europeana.metis.cache.redis.RedisProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
public class RedisInternalEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisInternalEnricher.class);
    private static final String CACHE_NAME_SEPARATOR = ":";
    private static final String CACHED_AGENT = "agent:";
    private static final String CACHED_CONCEPT = "concept:";
    private static final String CACHED_PLACE = "place:";
    private static final String CACHED_TIMESPAN = "timespan:";
    private static final String CACHED_ENTITY = "entity:";
    private static final String CACHED_PARENT = "parent:";
    private static final String CACHED_SAMEAS = "sameas";
    private static final String CACHED_URI = "uri";
    private static final String CACHED_ENTITY_DEF = "entity:def:";
    private static final String CACHED_ENTITY_WILDCARD = "entity:*";
    private static final String CACHED_ENRICHMENT_STATUS = "enrichmentstatus";
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final int LANGUAGE_TAG_LENGTH = 2;
    private static final int COUNT_OF_ITEMS_COLLECTED_TO_LOG = 100;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final List<EntityType> ENTITY_TYPES = RedisInternalEnricher.createEntityTypeList();
    private static final Pattern PATTERN_MATCHING_VERY_BROAD_TIMESPANS = Pattern.compile("http://semium.org/time/(ChronologicalPeriod$|Time$|(AD|BC)[1-9]x{3}$)");
    private final EnrichmentEntityDao entityDao;
    private final RedisProvider redisProvider;

    public RedisInternalEnricher(EnrichmentEntityDao entityDao, RedisProvider provider, boolean populate) {
        this.entityDao = entityDao;
        SimpleModule sm = new SimpleModule("test", Version.unknownVersion());
        sm.addSerializer((JsonSerializer)new ObjectIdSerializer());
        OBJECT_MAPPER.registerModule((Module)sm);
        this.redisProvider = provider;
        if (populate) {
            Jedis jedis = this.redisProvider.getJedis();
            if (jedis.exists(CACHED_ENRICHMENT_STATUS).booleanValue() && (StringUtils.equals((String)jedis.get(CACHED_ENRICHMENT_STATUS), (String)"started") || StringUtils.equals((String)jedis.get(CACHED_ENRICHMENT_STATUS), (String)"finished"))) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Status 'enrichmentstatus' exists with value: {}", (Object)this.check());
                }
            } else {
                LOGGER.info("Redis status 'enrichmentstatus' does not exist or is not in a 'started' or 'finished' state.");
                LOGGER.info("Re-populating Redis from Mongo");
                jedis.close();
                this.populate();
            }
        }
    }

    private static List<EntityType> createEntityTypeList() {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.add(new EntityType(EntityClass.AGENT, CACHED_AGENT));
        entityTypes.add(new EntityType(EntityClass.CONCEPT, CACHED_CONCEPT));
        entityTypes.add(new EntityType(EntityClass.PLACE, CACHED_PLACE));
        entityTypes.add(new EntityType(EntityClass.TIMESPAN, CACHED_TIMESPAN));
        return entityTypes;
    }

    public final String check() {
        Jedis jedis = this.redisProvider.getJedis();
        String status = jedis.get(CACHED_ENRICHMENT_STATUS);
        jedis.close();
        return status;
    }

    public void recreate() {
        LOGGER.info("Recreate triggered.");
        Jedis jedis = this.redisProvider.getJedis();
        jedis.del(CACHED_ENRICHMENT_STATUS);
        jedis.close();
        this.populate();
    }

    public void emptyCache() {
        LOGGER.info("Empty cache");
        Jedis jedis = this.redisProvider.getJedis();
        jedis.flushAll();
        jedis.close();
    }

    public void remove(List<String> uris) {
        Jedis jedis = this.redisProvider.getJedis();
        for (String str : uris) {
            jedis.del("concept:parent:" + str);
            jedis.del("agent:parent:" + str);
            jedis.del("timespan:parent:" + str);
            jedis.del("place:parent:" + str);
            jedis.hdel("concept:uri", new String[]{str});
            jedis.hdel("agent:uri", new String[]{str});
            jedis.hdel("timespan:uri", new String[]{str});
            jedis.hdel("place:uri", new String[]{str});
            this.removeKeysForEntity(jedis, str, CACHED_CONCEPT);
            this.removeKeysForEntity(jedis, str, CACHED_AGENT);
            this.removeKeysForEntity(jedis, str, CACHED_PLACE);
            this.removeKeysForEntity(jedis, str, CACHED_TIMESPAN);
        }
        jedis.close();
    }

    private void removeKeysForEntity(Jedis jedis, String str, String cachedEntity) {
        Set conceptKeys = jedis.keys(cachedEntity + CACHED_ENTITY_WILDCARD);
        for (String key : conceptKeys) {
            jedis.srem(key, new String[]{str});
        }
    }

    private void populate() {
        long startTime = System.currentTimeMillis();
        this.setStatus("started");
        for (EntityType type : ENTITY_TYPES) {
            this.loadEntities(type);
        }
        this.setStatus("finished");
        int totalSeconds = (int)((System.currentTimeMillis() - startTime) / 1000L);
        int seconds = totalSeconds % 60;
        int minutes = (totalSeconds - seconds) / 60;
        LOGGER.info("Time spent in populating Redis. minutes: {}, seconds: {}", (Object)minutes, (Object)seconds);
    }

    private void setStatus(String status) {
        Jedis jedis = this.redisProvider.getJedis();
        jedis.set(CACHED_ENRICHMENT_STATUS, status);
        jedis.close();
    }

    private void loadEntities(EntityType entityType) {
        Jedis jedis = this.redisProvider.getJedis();
        List<MongoTerm> terms = this.entityDao.getAllMongoTerms(entityType.entityClass);
        int termCount = terms.size();
        LOGGER.info("Found entities of type {}: {}", (Object)entityType.entityClass, (Object)termCount);
        int i = 0;
        for (MongoTerm term : terms) {
            this.loadEntity(entityType, term, jedis);
            if (++i % 100 != 0) continue;
            LOGGER.info("Elements added: {} out of: {}", (Object)i, (Object)termCount);
        }
        jedis.close();
    }

    private void loadEntity(EntityType entityType, MongoTerm term, Jedis jedis) {
        MongoTermList<ContextualClassImpl> termList = this.entityDao.findByCode(term.getCodeUri(), entityType.entityClass);
        if (termList != null) {
            try {
                EntityWrapper entityWrapper = new EntityWrapper();
                entityWrapper.setOriginalField("");
                entityWrapper.setEntityClass(entityType.entityClass);
                entityWrapper.setContextualEntity(this.getObjectMapper().writeValueAsString((Object)termList.getRepresentation()));
                entityWrapper.setOriginalValue(term.getOriginalLabel());
                entityWrapper.setUrl(term.getCodeUri());
                jedis.sadd(entityType.cachedEntityPrefix + CACHED_ENTITY_DEF + term.getLabel(), new String[]{term.getCodeUri()});
                if (term.getLang() != null) {
                    jedis.sadd(entityType.cachedEntityPrefix + CACHED_ENTITY + term.getLang() + CACHE_NAME_SEPARATOR + term.getLabel(), new String[]{term.getCodeUri()});
                }
                jedis.hset(entityType.cachedEntityPrefix + CACHED_URI, term.getCodeUri(), OBJECT_MAPPER.writeValueAsString((Object)entityWrapper));
                List<String> parents = this.findParents(termList.getParent(), entityType.entityClass);
                if (!parents.isEmpty()) {
                    jedis.sadd(entityType.cachedEntityPrefix + CACHED_PARENT + term.getCodeUri(), parents.toArray(new String[0]));
                }
                if (termList.getOwlSameAs() != null) {
                    for (String sameAs : termList.getOwlSameAs()) {
                        jedis.hset(entityType.cachedEntityPrefix + CACHED_SAMEAS, sameAs, term.getCodeUri());
                    }
                }
            }
            catch (IOException exception) {
                LOGGER.warn("", (Throwable)exception);
            }
        }
    }

    protected List<EntityWrapper> tag(List<InputValue> values) throws IOException {
        ArrayList<EntityWrapper> entities = new ArrayList<EntityWrapper>();
        for (InputValue inputValue : values) {
            if (inputValue.getVocabularies() == null) continue;
            for (EntityClass voc : inputValue.getVocabularies()) {
                entities.addAll(this.findEntities(inputValue.getValue().toLowerCase(Locale.US), inputValue.getOriginalField(), inputValue.getLanguage(), voc));
            }
        }
        return entities;
    }

    private List<String> findParents(String parent, EntityClass entityClass) {
        ArrayList<String> parentEntities = new ArrayList<String>();
        MongoTermList<ContextualClassImpl> parents = this.entityDao.findByCode(parent, entityClass);
        if (parents != null) {
            parentEntities.add(parents.getCodeUri());
            if (parents.getParent() != null && !parent.equals(parents.getParent())) {
                parentEntities.addAll(this.findParents(parents.getParent(), entityClass));
            }
        }
        return parentEntities;
    }

    private List<EntityWrapper> findEntities(String lowerCase, String field, String lang, EntityClass entityClass) throws IOException {
        String cachedEntityPrefix;
        switch (entityClass) {
            case AGENT: {
                cachedEntityPrefix = CACHED_AGENT;
                break;
            }
            case CONCEPT: {
                cachedEntityPrefix = CACHED_CONCEPT;
                break;
            }
            case PLACE: {
                cachedEntityPrefix = CACHED_PLACE;
                break;
            }
            case TIMESPAN: {
                cachedEntityPrefix = CACHED_TIMESPAN;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown entity class: " + entityClass.name());
            }
        }
        return this.findEntities(lowerCase, field, lang, cachedEntityPrefix);
    }

    private List<EntityWrapper> findEntities(String value, String originalField, String lang, String cachedEntityPrefix) throws IOException {
        String cacheKey;
        Jedis jedis;
        HashSet<EntityWrapper> result = new HashSet<EntityWrapper>();
        if (StringUtils.isEmpty((String)lang) || lang.length() != 2) {
            lang = "def";
        }
        if (!(jedis = this.redisProvider.getJedis()).isConnected()) {
            jedis.connect();
        }
        if (jedis.exists(cacheKey = cachedEntityPrefix + CACHED_ENTITY + lang + CACHE_NAME_SEPARATOR + value).booleanValue()) {
            Set urisToCheck = jedis.smembers(cacheKey);
            for (String uri : urisToCheck) {
                EntityWrapper entity = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget(cachedEntityPrefix + CACHED_URI, uri), EntityWrapper.class);
                entity.setOriginalField(originalField);
                result.add(entity);
                result.addAll(this.findParentEntities(cachedEntityPrefix, jedis, uri));
            }
        }
        jedis.close();
        return new ArrayList<EntityWrapper>(result);
    }

    private Set<EntityWrapper> findParentEntities(String cachedEntityPrefix, Jedis jedis, String uri) throws IOException {
        HashSet<EntityWrapper> entityWrapperSet = new HashSet<EntityWrapper>();
        if (jedis.exists(cachedEntityPrefix + CACHED_PARENT + uri).booleanValue()) {
            Set parentEntityUrls = jedis.smembers(cachedEntityPrefix + CACHED_PARENT + uri);
            for (String parentEntityUrl : parentEntityUrls) {
                if (CACHED_TIMESPAN.equals(cachedEntityPrefix) && PATTERN_MATCHING_VERY_BROAD_TIMESPANS.matcher(parentEntityUrl).matches()) continue;
                EntityWrapper parentEntityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget(cachedEntityPrefix + CACHED_URI, parentEntityUrl), EntityWrapper.class);
                entityWrapperSet.add(parentEntityWrapper);
            }
        }
        return entityWrapperSet;
    }

    public EntityWrapper getByUri(String uri) throws IOException {
        Jedis jedis = this.redisProvider.getJedis();
        EntityWrapper entityWrapper = null;
        entityWrapper = this.getEntityWrapper(uri, jedis, entityWrapper, CACHED_AGENT);
        entityWrapper = this.getEntityWrapper(uri, jedis, entityWrapper, CACHED_CONCEPT);
        entityWrapper = this.getEntityWrapper(uri, jedis, entityWrapper, CACHED_TIMESPAN);
        entityWrapper = this.getEntityWrapper(uri, jedis, entityWrapper, CACHED_PLACE);
        entityWrapper = this.getEntityWrapperFromSameAs(uri, jedis, entityWrapper, CACHED_AGENT);
        entityWrapper = this.getEntityWrapperFromSameAs(uri, jedis, entityWrapper, CACHED_CONCEPT);
        entityWrapper = this.getEntityWrapperFromSameAs(uri, jedis, entityWrapper, CACHED_TIMESPAN);
        entityWrapper = this.getEntityWrapperFromSameAs(uri, jedis, entityWrapper, CACHED_PLACE);
        jedis.close();
        return entityWrapper;
    }

    private EntityWrapper getEntityWrapperFromSameAs(String uri, Jedis jedis, EntityWrapper entityWrapper, String cachedEntity) throws IOException {
        if (jedis.hexists(cachedEntity + CACHED_SAMEAS, uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget(cachedEntity + CACHED_URI, jedis.hget(cachedEntity + CACHED_SAMEAS, uri)), EntityWrapper.class);
        }
        return entityWrapper;
    }

    private EntityWrapper getEntityWrapper(String uri, Jedis jedis, EntityWrapper entityWrapper, String cachedEntity) throws IOException {
        if (jedis.hexists(cachedEntity + CACHED_URI, uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget(cachedEntity + CACHED_URI, uri), EntityWrapper.class);
        }
        return entityWrapper;
    }

    private ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    private static class EntityType {
        private final EntityClass entityClass;
        private final String cachedEntityPrefix;

        EntityType(EntityClass entityClass, String cachedEntityPrefix) {
            this.entityClass = entityClass;
            this.cachedEntityPrefix = cachedEntityPrefix;
        }
    }
}

