/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.corelib.definitions.edm.entity.Organization;
import eu.europeana.corelib.solr.entity.ContextualClassImpl;
import eu.europeana.corelib.solr.entity.OrganizationImpl;
import eu.europeana.enrichment.api.internal.MongoTermList;
import eu.europeana.enrichment.api.internal.OrganizationTermList;
import eu.europeana.enrichment.utils.EnrichmentEntityDao;
import eu.europeana.enrichment.utils.EntityClass;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityService
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityService.class);
    private final EnrichmentEntityDao entityDao;

    public EntityService(String mongoHost, int mongoPort) {
        this.entityDao = new EnrichmentEntityDao(mongoHost, mongoPort);
    }

    public EntityService(String mongoConnectionUrl) {
        this.entityDao = new EnrichmentEntityDao(mongoConnectionUrl);
    }

    @Override
    public void close() {
        this.entityDao.close();
    }

    public OrganizationTermList storeOrganization(Organization org, Date created, Date modified) {
        OrganizationTermList termList = this.organizationToOrganizationTermList((OrganizationImpl)org, created, modified);
        MongoTermList<ContextualClassImpl> storedOrg = this.entityDao.findByCode(org.getAbout(), EntityClass.ORGANIZATION);
        if (storedOrg != null) {
            termList.setId(storedOrg.getId());
        }
        this.entityDao.deleteOrganizationTerms(org.getAbout());
        int newLabels = this.entityDao.storeEntityLabels((ContextualClassImpl)((OrganizationImpl)org), EntityClass.ORGANIZATION);
        LOGGER.trace("Stored new lables: {}", (Object)newLabels);
        return this.entityDao.storeMongoTermList((MongoTermList<? extends ContextualClassImpl>)termList);
    }

    public List<String> getOrganizationRoles(Organization org) {
        return (List)org.getEdmEuropeanaRole().get(Locale.ENGLISH.toString());
    }

    public Organization getOrganizationById(String uri) {
        MongoTermList<ContextualClassImpl> storedOrg = this.entityDao.findByCode(uri, EntityClass.ORGANIZATION);
        if (storedOrg == null) {
            return null;
        }
        return (OrganizationImpl)storedOrg.getRepresentation();
    }

    public List<String> findExistingOrganizations(List<String> organizationIds) {
        ArrayList<String> res = new ArrayList<String>();
        for (String id : organizationIds) {
            Organization organization = this.getOrganizationById(id);
            if (organization == null) continue;
            res.add(organization.getAbout());
        }
        return res;
    }

    public void deleteOrganizations(List<String> organizationIds) {
        this.entityDao.delete(organizationIds);
    }

    public void deleteOrganization(String organizationId) {
        this.entityDao.deleteOrganizations(organizationId);
        this.entityDao.deleteOrganizationTerms(organizationId);
    }

    private OrganizationTermList organizationToOrganizationTermList(OrganizationImpl organization, Date created, Date modified) {
        OrganizationTermList termList = new OrganizationTermList();
        termList.setCodeUri(organization.getAbout());
        termList.setRepresentation(organization);
        termList.setEntityType(OrganizationImpl.class.getSimpleName());
        if (created == null) {
            termList.setCreated(new Date());
        } else {
            termList.setCreated(created);
        }
        termList.setModified(modified);
        return termList;
    }

    public Date getLastOrganizationImportDate() {
        return this.entityDao.getLastModifiedDate(EntityClass.ORGANIZATION);
    }
}

