/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import eu.europeana.corelib.solr.entity.ContextualClassImpl;
import eu.europeana.enrichment.api.internal.AgentTermList;
import eu.europeana.enrichment.api.internal.ConceptTermList;
import eu.europeana.enrichment.api.internal.MongoTerm;
import eu.europeana.enrichment.api.internal.MongoTermList;
import eu.europeana.enrichment.api.internal.OrganizationTermList;
import eu.europeana.enrichment.api.internal.PlaceTermList;
import eu.europeana.enrichment.api.internal.TimespanTermList;
import eu.europeana.enrichment.utils.EntityClass;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.mongojack.DBCursor;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichmentEntityDao
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichmentEntityDao.class);
    private static final String ENTITY_TYPE_PROPERTY = "entityType";
    private static final String PLACE_TYPE = "PlaceImpl";
    private static final String CONCEPT_TYPE = "ConceptImpl";
    private static final String AGENT_TYPE = "AgentImpl";
    private static final String TIMESPAN_TYPE = "TimespanImpl";
    private static final String ORGANIZATION_TYPE = "OrganizationImpl";
    private static final String AGENT_TABLE = "people";
    private static final String CONCEPT_TABLE = "concept";
    private static final String PLACE_TABLE = "place";
    private static final String TIMESPAN_TABLE = "period";
    private static final String ORGANIZATION_TABLE = "organization";
    private static final String TERMLIST_TABLE = "TermList";
    private static final String UNIQUE_PROPERTY = "unique";
    private static final String TERM_SAME_AS = "owlSameAs";
    private static final String TERM_CODE_URI = "codeUri";
    private static final String TERM_LANG = "lang";
    private static final String TERM_LABEL = "label";
    private static final String TERM_MODIFIED = "modified";
    private JacksonDBCollection<ConceptTermList, String> cColl;
    private JacksonDBCollection<PlaceTermList, String> pColl;
    private JacksonDBCollection<TimespanTermList, String> tColl;
    private JacksonDBCollection<AgentTermList, String> aColl;
    private JacksonDBCollection<OrganizationTermList, String> oColl;
    private DB db;
    private final MongoClient mongo;

    public EnrichmentEntityDao(String host, int port) {
        this.mongo = new MongoClient(host, port);
    }

    public EnrichmentEntityDao(String connectionUrl) {
        this.mongo = new MongoClient(new MongoClientURI(connectionUrl));
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    private synchronized void initDbIfNeeded() {
        if (this.db != null) {
            return;
        }
        try {
            LOGGER.info("Creating Mongo connection to host {}.", (Object)this.mongo.getAddress());
            this.db = this.mongo.getDB("annocultor_db");
            boolean exist = this.db.collectionExists(TERMLIST_TABLE);
            this.cColl = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(TERMLIST_TABLE), ConceptTermList.class, String.class);
            this.aColl = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(TERMLIST_TABLE), AgentTermList.class, String.class);
            this.tColl = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(TERMLIST_TABLE), TimespanTermList.class, String.class);
            this.pColl = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(TERMLIST_TABLE), PlaceTermList.class, String.class);
            this.oColl = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(TERMLIST_TABLE), OrganizationTermList.class, String.class);
            if (!exist) {
                this.cColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                this.cColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.cColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.aColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                this.aColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.aColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.tColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                this.tColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.tColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.pColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                this.pColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.pColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.oColl.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
                this.oColl.createIndex((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
                this.oColl.createIndex((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.FALSE));
            }
        }
        catch (MongoException e) {
            LOGGER.error("Error accessing mongo", (Throwable)e);
        }
    }

    public List<String> delete(List<String> uris) {
        this.initDbIfNeeded();
        ArrayList<String> retUris = new ArrayList<String>();
        for (String uri : uris) {
            retUris.add(uri);
            retUris.addAll(this.deletePlaces(uri));
            retUris.addAll(this.deleteConcepts(uri));
            retUris.addAll(this.deleteAgents(uri));
            retUris.addAll(this.deleteTimespan(uri));
            retUris.addAll(this.deleteOrganizations(uri));
        }
        return retUris;
    }

    private List<String> deleteTimespan(String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        this.tColl.remove(((DBCursor)this.tColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection termT = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(TIMESPAN_TABLE), MongoTerm.class, String.class);
        termT.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termT.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        termT.remove(((DBCursor)termT.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        DBCursor objT = this.tColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)TIMESPAN_TYPE));
        if (objT.hasNext()) {
            String origT = ((TimespanTermList)objT.next()).getCodeUri();
            retUris.add(origT);
            this.tColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origT));
            termT.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origT));
        }
        return retUris;
    }

    private List<String> deleteAgents(String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        this.aColl.remove(((DBCursor)this.aColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection termA = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(AGENT_TABLE), MongoTerm.class, String.class);
        termA.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termA.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        termA.remove(((DBCursor)termA.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        DBCursor objA = this.aColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)AGENT_TYPE));
        if (objA.hasNext()) {
            String origA = ((AgentTermList)objA.next()).getCodeUri();
            retUris.add(origA);
            this.aColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origA));
            termA.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origA));
        }
        return retUris;
    }

    public List<String> deleteOrganizations(String uri) {
        this.initDbIfNeeded();
        ArrayList<String> retUris = new ArrayList<String>();
        this.oColl.remove(((DBCursor)this.oColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection<MongoTerm, String> termA = this.deleteOrganizationTerms(uri);
        termA.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termA.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        DBCursor objA = this.oColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)ORGANIZATION_TYPE));
        if (objA.hasNext()) {
            String origA = ((OrganizationTermList)objA.next()).getCodeUri();
            retUris.add(origA);
            this.oColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origA));
            termA.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origA));
        }
        return retUris;
    }

    public JacksonDBCollection<MongoTerm, String> deleteOrganizationTerms(String uri) {
        this.initDbIfNeeded();
        JacksonDBCollection termA = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(ORGANIZATION_TABLE), MongoTerm.class, String.class);
        termA.remove(((DBCursor)termA.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        return termA;
    }

    private List<String> deleteConcepts(String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        this.cColl.remove(((DBCursor)this.cColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection termC = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(CONCEPT_TABLE), MongoTerm.class, String.class);
        termC.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termC.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        termC.remove(((DBCursor)termC.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        DBCursor objC = this.cColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)CONCEPT_TYPE));
        if (objC.hasNext()) {
            String origC = ((ConceptTermList)objC.next()).getCodeUri();
            retUris.add(origC);
            this.cColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origC));
            termC.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origC));
        }
        return retUris;
    }

    private List<String> deletePlaces(String uri) {
        ArrayList<String> retUris = new ArrayList<String>();
        this.pColl.remove(((DBCursor)this.pColl.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        JacksonDBCollection termP = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(PLACE_TABLE), MongoTerm.class, String.class);
        termP.createIndex((DBObject)new BasicDBObject(TERM_LABEL, (Object)1).append(TERM_LANG, (Object)1).append(TERM_CODE_URI, (Object)1), (DBObject)new BasicDBObject(UNIQUE_PROPERTY, (Object)Boolean.TRUE));
        termP.createIndex((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)1));
        termP.remove(((DBCursor)termP.find().is(TERM_CODE_URI, (Object)uri)).getQuery());
        DBCursor objP = this.pColl.find((DBObject)new BasicDBObject(TERM_SAME_AS, (Object)uri).append(ENTITY_TYPE_PROPERTY, (Object)PLACE_TYPE));
        if (objP.hasNext()) {
            String origP = ((PlaceTermList)objP.next()).getCodeUri();
            retUris.add(origP);
            this.pColl.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origP));
            termP.remove((DBObject)new BasicDBObject(TERM_CODE_URI, (Object)origP));
        }
        return retUris;
    }

    public MongoTermList<ContextualClassImpl> findByCode(String codeUri, EntityClass entityClass) {
        ConceptTermList result;
        this.initDbIfNeeded();
        switch (entityClass) {
            case CONCEPT: {
                result = this.findConceptByCode(codeUri);
                break;
            }
            case PLACE: {
                result = this.findPlaceByCode(codeUri);
                break;
            }
            case AGENT: {
                result = this.findAgentByCode(codeUri);
                break;
            }
            case TIMESPAN: {
                result = this.findTimespanByCode(codeUri);
                break;
            }
            case ORGANIZATION: {
                result = this.findOrganizationByCode(codeUri);
                break;
            }
            default: {
                result = null;
            }
        }
        return MongoTermList.cast((MongoTermList)result);
    }

    private TimespanTermList findTimespanByCode(String codeUri) {
        DBCursor curs = (DBCursor)this.tColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)TIMESPAN_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (TimespanTermList)curs.next();
        }
        return null;
    }

    private AgentTermList findAgentByCode(String codeUri) {
        DBCursor curs = (DBCursor)this.aColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)AGENT_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (AgentTermList)curs.next();
        }
        return null;
    }

    private PlaceTermList findPlaceByCode(String codeUri) {
        DBCursor curs = (DBCursor)this.pColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)PLACE_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (PlaceTermList)curs.next();
        }
        return null;
    }

    private ConceptTermList findConceptByCode(String codeUri) {
        DBCursor curs = (DBCursor)this.cColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)CONCEPT_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (ConceptTermList)curs.next();
        }
        return null;
    }

    private OrganizationTermList findOrganizationByCode(String codeUri) {
        DBCursor curs = (DBCursor)this.oColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)ORGANIZATION_TYPE)).is(TERM_CODE_URI, (Object)codeUri);
        if (curs.hasNext()) {
            return (OrganizationTermList)curs.next();
        }
        return null;
    }

    private String getTableName(EntityClass entityClass) {
        String result;
        switch (entityClass) {
            case AGENT: {
                result = AGENT_TABLE;
                break;
            }
            case CONCEPT: {
                result = CONCEPT_TABLE;
                break;
            }
            case PLACE: {
                result = PLACE_TABLE;
                break;
            }
            case TIMESPAN: {
                result = TIMESPAN_TABLE;
                break;
            }
            case ORGANIZATION: {
                result = ORGANIZATION_TABLE;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown entity: " + entityClass);
            }
        }
        return result;
    }

    private static String getTypeName(EntityClass entityClass) {
        if (entityClass != EntityClass.ORGANIZATION) {
            throw new IllegalStateException("Unknown entity: " + entityClass);
        }
        String result = ORGANIZATION_TYPE;
        return result;
    }

    public List<MongoTerm> getAllMongoTerms(EntityClass entityClass) {
        this.initDbIfNeeded();
        JacksonDBCollection collection = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(this.getTableName(entityClass)), MongoTerm.class, String.class);
        DBCursor curs = collection.find();
        return StreamSupport.stream(curs.spliterator(), false).collect(Collectors.toList());
    }

    public OrganizationTermList storeMongoTermList(MongoTermList<? extends ContextualClassImpl> termList) {
        this.initDbIfNeeded();
        String type = termList.getEntityType();
        if (ORGANIZATION_TYPE.equals(type)) {
            return this.saveOrganization((OrganizationTermList)termList);
        }
        throw new IllegalArgumentException("insertion of MongoTermList of type: " + type + " not supported yet!");
    }

    private OrganizationTermList saveOrganization(OrganizationTermList termList) {
        return (OrganizationTermList)this.oColl.save((Object)termList).getSavedObject();
    }

    public int storeEntityLabels(ContextualClassImpl entity, EntityClass entityClass) {
        this.initDbIfNeeded();
        String collection = this.getTableName(entityClass);
        JacksonDBCollection termColl = JacksonDBCollection.wrap((DBCollection)this.db.getCollection(collection), MongoTerm.class, String.class);
        List<MongoTerm> terms = EnrichmentEntityDao.createListOfMongoTerms(entity);
        WriteResult res = termColl.insert(terms);
        return res.getN();
    }

    private static List<MongoTerm> createListOfMongoTerms(ContextualClassImpl entity) {
        ArrayList<MongoTerm> terms = new ArrayList<MongoTerm>();
        for (Map.Entry prefLabel : entity.getPrefLabel().entrySet()) {
            for (String label : (List)prefLabel.getValue()) {
                MongoTerm term = new MongoTerm();
                term.setCodeUri(entity.getAbout());
                term.setLabel(label.toLowerCase());
                String lang = (String)prefLabel.getKey();
                term.setOriginalLabel(label);
                term.setLang(lang);
                terms.add(term);
            }
        }
        return terms;
    }

    public Date getLastModifiedDate(EntityClass entityClass) {
        this.initDbIfNeeded();
        DBCursor cursor = this.oColl.find((DBObject)new BasicDBObject(ENTITY_TYPE_PROPERTY, (Object)EnrichmentEntityDao.getTypeName(entityClass))).sort((DBObject)DBSort.desc((String)TERM_MODIFIED)).limit(1);
        if (cursor.size() == 0) {
            return null;
        }
        OrganizationTermList lastModifiedOrg = (OrganizationTermList)cursor.next();
        return lastModifiedOrg.getModified();
    }
}

