/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.enrichment.api.external.EntityWrapper;
import eu.europeana.enrichment.service.RedisInternalEnricher;
import eu.europeana.enrichment.utils.InputValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Enricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(Enricher.class);
    private final RedisInternalEnricher redisEnricher;

    @Autowired
    public Enricher(RedisInternalEnricher redisEnricher) {
        this.redisEnricher = redisEnricher;
    }

    public List<EntityWrapper> tagExternal(List<InputValue> values) throws IOException {
        return new ArrayList<EntityWrapper>(this.redisEnricher.tag(values));
    }

    public EntityWrapper getByUri(String uri) {
        try {
            return this.redisEnricher.getByUri(uri);
        }
        catch (IOException | RuntimeException e) {
            LOGGER.warn("Unable to rerieve entity form uri {}", (Throwable)e);
            return null;
        }
    }
}

