/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service.zoho.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.enrichment.api.external.model.zoho.ZohoOrganization;
import eu.europeana.enrichment.api.external.model.zoho.ZohoResponseField;
import eu.europeana.enrichment.service.exception.ZohoAccessException;
import eu.europeana.metis.authentication.dao.ZohoApiFields;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ZohoOrganizationAdapter
implements ZohoOrganization {
    private static final String ACCOUNTID = "ACCOUNTID";
    private static final String ACCOUNT_NAME = "Account Name";
    private static final String ACCOUNT_OWNER = "Account Owner";
    private static final String LANG_ORGANIZATION_NAME = "Lang Organisation Name";
    private static final String WEBSITE = "Website";
    private static final String DESCRIPTION = "Description";
    private static final String DOMAIN = "Domain";
    private static final String STREET = "Street";
    private static final String CITY = "City";
    private static final String ZIP_CODE = "ZIP code";
    private static final String COUNTRY = "Country";
    private static final String ALTERNATIVE = "Alternative";
    private static final String LANG_ALTERNATIVE = "Lang Alternative";
    private static final String SCOPE = "Scope";
    private static final String SAME_AS = "SameAs";
    private static final String ORGANIZATION_ROLE = "Organisation Role";
    private static final String GEOGRAPHIC_LEVEL = "Geographic Level";
    private static final String ACRONYM = "Acronym";
    private static final String LANG_ACRONYM = "Lang Acronym";
    private static final String ORGNAIZATION_COUNTRY = "Organisation Country";
    private static final String LOGO = "Logo (link to WikimediaCommons)";
    private static final String SECTOR = "Sector";
    private static final String POST_BOX = "PO box";
    private static final String MODIFIED = "Modified Time";
    private static final String CREATED = "Created Time";
    private static final String MODIFIED_BY = "Modified By";
    private static final int MAX_ALTERNATIVES = 5;
    private static final int MAX_LANG_ALTERNATIVES = 5;
    private static final int MAX_SAME_AS = 3;
    private List<ZohoResponseField> organizationFields;

    public ZohoOrganizationAdapter(JsonNode response) throws ZohoAccessException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.organizationFields = (List)mapper.readValue(response.toString(), (TypeReference)new TypeReference<List<ZohoResponseField>>(){});
        }
        catch (IOException e) {
            throw new ZohoAccessException("Cannot parse zoho response ", e);
        }
    }

    private String getContent(String fieldName) {
        ZohoResponseField zohoFieldObject = new ZohoResponseField();
        zohoFieldObject.setVal(fieldName);
        int fieldIndex = this.organizationFields.indexOf(zohoFieldObject);
        if (fieldIndex > -1) {
            return this.organizationFields.get(fieldIndex).getContent();
        }
        return null;
    }

    public String toString() {
        return this.getZohoId() + ", " + this.getOrganizationName();
    }

    public String getZohoId() {
        return this.getContent(ACCOUNTID);
    }

    public String getOrganizationName() {
        return this.getContent(ACCOUNT_NAME);
    }

    public List<String> getAlternativeOrganizationName() {
        return this.getFieldArray(ALTERNATIVE, 5);
    }

    public String getOrganizationOwner() {
        return this.getContent(ACCOUNT_OWNER);
    }

    public String getAcronym() {
        return this.getContent(ACRONYM);
    }

    public String getLangAcronym() {
        return this.getContent(LANG_ACRONYM);
    }

    public String getDomain() {
        return this.getContent(DOMAIN);
    }

    public String getOrganizationCountry() {
        return this.getContent(ORGNAIZATION_COUNTRY);
    }

    public String getSector() {
        return this.getContent(SECTOR);
    }

    public String getLogo() {
        return this.getContent(LOGO);
    }

    public String getWebsite() {
        return this.getContent(WEBSITE);
    }

    public String getLanguageForOrganizationName() {
        return this.getContent(LANG_ORGANIZATION_NAME);
    }

    public List<String> getAlternativeLanguage() {
        return this.getFieldArray(LANG_ALTERNATIVE, 5);
    }

    private List<String> getFieldArray(String fieldBaseName, int size) {
        ArrayList<String> res = new ArrayList<String>(size);
        String fieldName = fieldBaseName + " %d";
        for (int i = 0; i < size; ++i) {
            String fieldValue = this.getContent(String.format(fieldName, i));
            if (!StringUtils.isNotBlank((CharSequence)fieldValue)) continue;
            res.add(fieldValue);
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    public String getRole() {
        return this.getContent(ORGANIZATION_ROLE);
    }

    public String getScope() {
        return this.getContent(SCOPE);
    }

    public String getGeographicLevel() {
        return this.getContent(GEOGRAPHIC_LEVEL);
    }

    public List<String> getSameAs() {
        return this.getFieldArray(SAME_AS, 3);
    }

    public String getPostBox() {
        return this.getContent(POST_BOX);
    }

    public String getStreet() {
        return this.getContent(STREET);
    }

    public String getCity() {
        return this.getContent(CITY);
    }

    public String getZipCode() {
        return this.getContent(ZIP_CODE);
    }

    public String getCountry() {
        return this.getContent(COUNTRY);
    }

    public String getDescription() {
        return this.getContent(DESCRIPTION);
    }

    public Date getModified() {
        String modified = this.getContent(MODIFIED);
        return this.getDateOrDefault(modified);
    }

    private Date getDateOrDefault(String dateTime) {
        if (StringUtils.isBlank((CharSequence)dateTime)) {
            return new Date(0L);
        }
        try {
            return ZohoApiFields.getZohoTimeFormatter().parse(dateTime);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse modified date. Wrong format: " + dateTime, e);
        }
    }

    public Date getCreated() {
        String created = this.getContent(CREATED);
        return this.getDateOrDefault(created);
    }

    public String getModifiedBy() {
        return this.getContent(MODIFIED_BY);
    }
}

