/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service.dao;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.metis.exception.GenericMetisException;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ZohoV2AccessDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZohoV2AccessDao.class);
    private final String zohoBaseUrl;
    private final String zohoAuthenticationToken;

    public ZohoV2AccessDao(String zohoBaseUrl, String zohoAuthenticationToken) {
        this.zohoBaseUrl = zohoBaseUrl;
        this.zohoAuthenticationToken = zohoAuthenticationToken;
    }

    public JsonNode getDeletedOrganizations(int startPage) throws GenericMetisException {
        String contactsSearchUrl = String.format("%s/%s/%s", this.zohoBaseUrl, "Accounts", "deleted");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)contactsSearchUrl).queryParam("page", new Object[]{startPage});
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.zohoAuthenticationToken);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        URI uri = builder.build().encode().toUri();
        LOGGER.trace("{}", (Object)uri);
        ResponseEntity response = restTemplate.exchange(uri, HttpMethod.GET, entity, String.class);
        String organisationsResponse = (String)response.getBody();
        LOGGER.debug(organisationsResponse);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(organisationsResponse);
        }
        catch (IOException e) {
            throw new GenericMetisException("Cannot parse zoho response: " + organisationsResponse, (Throwable)e);
        }
    }
}

