/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.corelib.solr.entity.ContextualClassImpl;
import eu.europeana.enrichment.api.external.EntityWrapper;
import eu.europeana.enrichment.api.external.ObjectIdSerializer;
import eu.europeana.enrichment.api.internal.MongoTerm;
import eu.europeana.enrichment.api.internal.MongoTermList;
import eu.europeana.enrichment.utils.EnrichmentEntityDao;
import eu.europeana.enrichment.utils.EntityClass;
import eu.europeana.enrichment.utils.InputValue;
import eu.europeana.metis.cache.redis.RedisProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
public class RedisInternalEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisInternalEnricher.class);
    private static final String CACHE_NAME_SEPARATOR = ":";
    private static final String CACHED_AGENT = "agent:";
    private static final String CACHED_CONCEPT = "concept:";
    private static final String CACHED_PLACE = "place:";
    private static final String CACHED_TIMESPAN = "timespan:";
    private static final String CACHED_ENTITY = "entity:";
    private static final String CACHED_PARENT = "parent:";
    private static final String CACHED_SAMEAS = "sameas";
    private static final String CACHED_URI = "uri";
    private static final String CACHED_ENTITY_DEF = "entity:def:";
    private static final String CACHED_ENTITY_WILDCARD = "entity:*";
    private static final String CACHED_ENRICHMENT_STATUS = "enrichmentstatus";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private final EnrichmentEntityDao entityDao;
    private final RedisProvider redisProvider;

    public RedisInternalEnricher(EnrichmentEntityDao entityDao, RedisProvider provider, boolean populate) {
        this.entityDao = entityDao;
        SimpleModule sm = new SimpleModule("test", Version.unknownVersion());
        sm.addSerializer((JsonSerializer)new ObjectIdSerializer());
        OBJECT_MAPPER.registerModule((Module)sm);
        this.redisProvider = provider;
        if (populate) {
            Jedis jedis = this.redisProvider.getJedis();
            if (!jedis.exists(CACHED_ENRICHMENT_STATUS).booleanValue() || !StringUtils.equals((String)jedis.get(CACHED_ENRICHMENT_STATUS), (String)"started") && !StringUtils.equals((String)jedis.get(CACHED_ENRICHMENT_STATUS), (String)"finished")) {
                LOGGER.info("Redis status 'enrichmentstatus' does not exist or is not in a 'started' or 'finished' state.");
                LOGGER.info("Re-populating Redis from Mongo");
                jedis.close();
                this.populate();
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Status 'enrichmentstatus' exists with value: {}", (Object)this.check());
            }
        }
    }

    public final String check() {
        Jedis jedis = this.redisProvider.getJedis();
        String status = jedis.get(CACHED_ENRICHMENT_STATUS);
        jedis.close();
        return status;
    }

    public void recreate() {
        LOGGER.info("Recreate triggered.");
        Jedis jedis = this.redisProvider.getJedis();
        jedis.del(CACHED_ENRICHMENT_STATUS);
        jedis.close();
        this.populate();
    }

    public void emptyCache() {
        LOGGER.info("Empty cache");
        Jedis jedis = this.redisProvider.getJedis();
        jedis.flushAll();
        jedis.close();
        this.populate();
    }

    public void remove(List<String> uris) {
        Jedis jedis = this.redisProvider.getJedis();
        for (String str : uris) {
            Object key2;
            jedis.del("concept:parent:" + str);
            jedis.del("agent:parent:" + str);
            jedis.del("timespan:parent:" + str);
            jedis.del("place:parent:" + str);
            jedis.hdel("concept:uri", new String[]{str});
            jedis.hdel("agent:uri", new String[]{str});
            jedis.hdel("timespan:uri", new String[]{str});
            jedis.hdel("place:uri", new String[]{str});
            Set conceptKeys = jedis.keys("concept:entity:*");
            for (Object key2 : conceptKeys) {
                jedis.srem((String)key2, new String[]{str});
            }
            Set agentKeys = jedis.keys("agent:entity:*");
            key2 = agentKeys.iterator();
            while (key2.hasNext()) {
                String key3 = (String)key2.next();
                jedis.srem(key3, new String[]{str});
            }
            Set placeKeys = jedis.keys("place:entity:*");
            for (String key4 : placeKeys) {
                jedis.srem(key4, new String[]{str});
            }
            Set timespanKeys = jedis.keys("timespan:entity:*");
            for (String key5 : timespanKeys) {
                jedis.srem(key5, new String[]{str});
            }
        }
        jedis.close();
    }

    private void populate() {
        long startTime = System.currentTimeMillis();
        this.setStatus("started");
        for (EntityType type : EntityType.values()) {
            this.loadEntities(type);
        }
        this.setStatus("finished");
        int totalSeconds = (int)((System.currentTimeMillis() - startTime) / 1000L);
        int seconds = totalSeconds % 60;
        int minutes = (totalSeconds - seconds) / 60;
        LOGGER.info("Time spent in populating Redis. minutes: {}, seconds: {}", (Object)minutes, (Object)seconds);
    }

    private void setStatus(String status) {
        Jedis jedis = this.redisProvider.getJedis();
        jedis.set(CACHED_ENRICHMENT_STATUS, status);
        jedis.close();
    }

    private void loadEntities(EntityType entityType) {
        Jedis jedis = this.redisProvider.getJedis();
        List<MongoTerm> terms = this.entityDao.getAllMongoTerms(entityType.entityClass);
        int termCount = terms.size();
        LOGGER.info("Found entities of type {}: {}", (Object)entityType.entityClass, (Object)termCount);
        int i = 0;
        for (MongoTerm term : terms) {
            this.loadEntity(entityType, term, jedis);
            if (++i % 100 != 0) continue;
            LOGGER.info("Elements added: {} out of: {}", (Object)i, (Object)termCount);
        }
        jedis.close();
    }

    private void loadEntity(EntityType entityType, MongoTerm term, Jedis jedis) {
        MongoTermList<ContextualClassImpl> termList = this.entityDao.findByCode(term.getCodeUri(), entityType.entityClass);
        if (termList != null) {
            try {
                EntityWrapper entityWrapper = new EntityWrapper();
                entityWrapper.setOriginalField("");
                entityWrapper.setEntityClass(entityType.entityClass);
                entityWrapper.setContextualEntity(this.getObjectMapper().writeValueAsString((Object)termList.getRepresentation()));
                entityWrapper.setOriginalValue(term.getOriginalLabel());
                entityWrapper.setUrl(term.getCodeUri());
                jedis.sadd(entityType.cachedEntityPrefix + CACHED_ENTITY_DEF + term.getLabel(), new String[]{term.getCodeUri()});
                if (term.getLang() != null) {
                    jedis.sadd(entityType.cachedEntityPrefix + CACHED_ENTITY + term.getLang() + CACHE_NAME_SEPARATOR + term.getLabel(), new String[]{term.getCodeUri()});
                }
                jedis.hset(entityType.cachedEntityPrefix + CACHED_URI, term.getCodeUri(), OBJECT_MAPPER.writeValueAsString((Object)entityWrapper));
                List<String> parents = this.findParents(termList.getParent(), entityType.entityClass);
                jedis.sadd(entityType.cachedEntityPrefix + CACHED_PARENT + term.getCodeUri(), parents.toArray(new String[0]));
                if (termList.getOwlSameAs() != null) {
                    for (String sameAs : termList.getOwlSameAs()) {
                        jedis.hset(entityType.cachedEntityPrefix + CACHED_SAMEAS, sameAs, term.getCodeUri());
                    }
                }
            }
            catch (IOException exception) {
                LOGGER.warn("", (Throwable)exception);
            }
        }
    }

    protected List<EntityWrapper> tag(List<InputValue> values) throws IOException {
        ArrayList<EntityWrapper> entities = new ArrayList<EntityWrapper>();
        for (InputValue inputValue : values) {
            if (inputValue.getVocabularies() == null) continue;
            for (EntityClass voc : inputValue.getVocabularies()) {
                entities.addAll(this.findEntities(inputValue.getValue().toLowerCase(Locale.US), inputValue.getOriginalField(), inputValue.getLanguage(), voc));
            }
        }
        return entities;
    }

    private List<String> findParents(String parent, EntityClass entityClass) throws IOException {
        ArrayList<String> parentEntities = new ArrayList<String>();
        MongoTermList<ContextualClassImpl> parents = this.entityDao.findByCode(parent, entityClass);
        if (parents != null) {
            parentEntities.add(parents.getCodeUri());
            if (parents.getParent() != null && !parent.equals(parents.getParent())) {
                if (entityClass == EntityClass.TIMESPAN) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException var5) {
                        Thread.currentThread().interrupt();
                    }
                }
                parentEntities.addAll(this.findParents(parents.getParent(), entityClass));
            }
        }
        return parentEntities;
    }

    private List<EntityWrapper> findEntities(String lowerCase, String field, String lang, EntityClass entityClass) throws IOException {
        String cachedEntityPrefix;
        switch (entityClass) {
            case AGENT: {
                cachedEntityPrefix = CACHED_AGENT;
                break;
            }
            case CONCEPT: {
                cachedEntityPrefix = CACHED_CONCEPT;
                break;
            }
            case PLACE: {
                cachedEntityPrefix = CACHED_PLACE;
                break;
            }
            case TIMESPAN: {
                cachedEntityPrefix = CACHED_TIMESPAN;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown entity class: " + entityClass.name());
            }
        }
        return this.findEntities(lowerCase, field, lang, cachedEntityPrefix);
    }

    private List<EntityWrapper> findEntities(String value, String originalField, String lang, String cachedEntityPrefix) throws IOException {
        Jedis jedis;
        HashSet<EntityWrapper> result = new HashSet<EntityWrapper>();
        if (StringUtils.isEmpty((String)lang) || lang.length() != 2) {
            lang = "def";
        }
        if (!(jedis = this.redisProvider.getJedis()).isConnected()) {
            jedis.connect();
        }
        if (jedis.exists(cachedEntityPrefix + CACHED_ENTITY + lang + CACHE_NAME_SEPARATOR + value).booleanValue()) {
            Set urisToCheck = jedis.smembers(cachedEntityPrefix + CACHED_ENTITY + lang + CACHE_NAME_SEPARATOR + value);
            for (String uri : urisToCheck) {
                EntityWrapper entity = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget(cachedEntityPrefix + CACHED_URI, uri), EntityWrapper.class);
                entity.setOriginalField(originalField);
                result.add(entity);
                if (!jedis.exists(cachedEntityPrefix + CACHED_PARENT + uri).booleanValue()) continue;
                Set parents = jedis.smembers(cachedEntityPrefix + CACHED_PARENT + uri);
                for (String parent : parents) {
                    EntityWrapper parentEntity = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget(cachedEntityPrefix + CACHED_URI, parent), EntityWrapper.class);
                    result.add(parentEntity);
                }
            }
        }
        jedis.close();
        return new ArrayList<EntityWrapper>(result);
    }

    public EntityWrapper getByUri(String uri) throws IOException {
        Jedis jedis = this.redisProvider.getJedis();
        EntityWrapper entityWrapper = null;
        if (jedis.hexists("agent:uri", uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget("agent:uri", uri), EntityWrapper.class);
        }
        if (jedis.hexists("concept:uri", uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget("concept:uri", uri), EntityWrapper.class);
        }
        if (jedis.hexists("timespan:uri", uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget("timespan:uri", uri), EntityWrapper.class);
        }
        if (jedis.hexists("place:uri", uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget("place:uri", uri), EntityWrapper.class);
        }
        if (jedis.hexists("agent:sameas", uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget("agent:uri", jedis.hget("agent:sameas", uri)), EntityWrapper.class);
        }
        if (jedis.hexists("concept:sameas", uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget("concept:uri", jedis.hget("concept:sameas", uri)), EntityWrapper.class);
        }
        if (jedis.hexists("timespan:sameas", uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget("timespan:uri", jedis.hget("timespan:sameas", uri)), EntityWrapper.class);
        }
        if (jedis.hexists("place:sameas", uri).booleanValue()) {
            entityWrapper = (EntityWrapper)OBJECT_MAPPER.readValue(jedis.hget("place:uri", jedis.hget("place:sameas", uri)), EntityWrapper.class);
        }
        jedis.close();
        return entityWrapper;
    }

    private ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    private static enum EntityType {
        AGENT(EntityClass.AGENT, "agent:"),
        CONCEPT(EntityClass.CONCEPT, "concept:"),
        PLACE(EntityClass.PLACE, "place:"),
        TIMESTAMP(EntityClass.TIMESPAN, "timespan:");

        public final EntityClass entityClass;
        public final String cachedEntityPrefix;

        private EntityType(EntityClass entityClass, String cachedEntityPrefix) {
            this.entityClass = entityClass;
            this.cachedEntityPrefix = cachedEntityPrefix;
        }
    }
}

