/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.enrichment.service;

import eu.europeana.corelib.definitions.edm.entity.Address;
import eu.europeana.corelib.definitions.edm.entity.Organization;
import eu.europeana.corelib.solr.entity.AddressImpl;
import eu.europeana.enrichment.api.external.model.TextProperty;
import eu.europeana.enrichment.api.external.model.WebResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EntityConverterUtils {
    private static final String UNDEFINED_LANGUAGE_KEY = "def";
    private static final int LANGUAGE_CODE_LENGTH = 2;

    public Map<String, List<String>> createMapWithLists(String key, String value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonMap(key, Collections.singletonList(value));
    }

    public Map<String, String> createMap(String key, String value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonMap(key, value);
    }

    List<String> createList(String value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonList(value);
    }

    public Map<String, List<String>> createMapWithLists(List<String> keys, List<String> values) {
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            resMap.put(EntityConverterUtils.toIsoLanguage(keys.get(i)), this.createList(values.get(i)));
        }
        return resMap;
    }

    public Map<String, List<String>> createMapWithListsFromTextPropertyListMerging(List<? extends TextProperty> textPropertyList) {
        return this.createMapWithListsFromTextPropertyList(textPropertyList, true);
    }

    public Map<String, List<String>> createMapWithListsFromTextPropertyListNonMerging(List<? extends TextProperty> textPropertyList) {
        return this.createMapWithListsFromTextPropertyList(textPropertyList, false);
    }

    private Map<String, List<String>> createMapWithListsFromTextPropertyList(List<? extends TextProperty> textPropertyList, boolean mergeLists) {
        if (textPropertyList == null) {
            return null;
        }
        BinaryOperator mergeOperator = mergeLists ? this::mergeStringLists : (list1, list2) -> list1;
        return textPropertyList.stream().collect(Collectors.toMap(property -> EntityConverterUtils.toIsoLanguage(property.getKey()), property -> this.createList(property.getValue()), mergeOperator));
    }

    public Map<String, String> createMapFromTextPropertyList(List<? extends TextProperty> textPropertyList) {
        if (textPropertyList == null) {
            return null;
        }
        return textPropertyList.stream().collect(Collectors.toMap(property -> EntityConverterUtils.toIsoLanguage(property.getKey()), TextProperty::getValue, (value1, value2) -> value1));
    }

    public String[] createStringArrayFromPartList(List<? extends WebResource> resources) {
        if (resources == null) {
            return null;
        }
        return (String[])resources.stream().map(WebResource::getResourceUri).toArray(String[]::new);
    }

    public Map<String, List<String>> createLanguageMapOfStringList(String language, String value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonMap(EntityConverterUtils.toIsoLanguage(language), this.createList(value));
    }

    public Map<String, List<String>> createLanguageMapOfStringList(String language, List<String> value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonMap(EntityConverterUtils.toIsoLanguage(language), value);
    }

    private static String toIsoLanguage(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return UNDEFINED_LANGUAGE_KEY;
        }
        return language.substring(0, 2).toLowerCase(Locale.US);
    }

    public Map<String, List<String>> mergeMapsWithLists(Map<String, List<String>> baseMap, Map<String, List<String>> addMap) {
        if (baseMap == null && addMap == null) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (baseMap != null) {
            result.putAll(baseMap);
        }
        if (addMap != null) {
            for (Map.Entry<String, List<String>> entry : addMap.entrySet()) {
                result.merge(entry.getKey(), new ArrayList(entry.getValue()), this::mergeStringLists);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public Map<String, List<String>> mergeMapsWithSingletonLists(Map<String, List<String>> baseMap, Map<String, List<String>> addMap, Map<String, List<String>> notMergedMap) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(baseMap);
        for (Map.Entry<String, List<String>> entry : addMap.entrySet()) {
            String key = entry.getKey();
            if (!result.containsKey(key)) {
                result.put(key, new ArrayList(entry.getValue()));
                continue;
            }
            List unmergedValues = entry.getValue().stream().distinct().filter(value -> !((List)result.get(key)).contains(value)).collect(Collectors.toList());
            if (unmergedValues.isEmpty()) continue;
            notMergedMap.merge(key, unmergedValues, this::mergeStringLists);
        }
        return result;
    }

    public List<String> mergeStringLists(List<String> baseList, List<String> addList) {
        HashSet<String> result = new HashSet<String>();
        if (baseList != null) {
            result.addAll(baseList);
        }
        if (addList != null) {
            result.addAll(addList);
        }
        return result.isEmpty() ? null : new ArrayList(result);
    }

    public String[] mergeStringArrays(String[] base, String[] add) {
        List<String> baseList = base == null ? Collections.emptyList() : Arrays.asList(base);
        List<String> addList = add == null ? Collections.emptyList() : Arrays.asList(add);
        List<String> mergedList = this.mergeStringLists(baseList, addList);
        return mergedList == null ? null : mergedList.toArray(new String[0]);
    }

    public void mergeAddress(Organization baseOrganization, Organization addOrganization) {
        Address baseAddress;
        boolean baseHasAddressData = baseOrganization.getAddress() != null ? StringUtils.isNotEmpty((CharSequence)(baseAddress = baseOrganization.getAddress()).getVcardLocality()) || StringUtils.isNotEmpty((CharSequence)baseAddress.getVcardPostalCode()) || StringUtils.isNotEmpty((CharSequence)baseAddress.getVcardPostOfficeBox()) || StringUtils.isNotEmpty((CharSequence)baseAddress.getVcardStreetAddress()) : false;
        if (baseHasAddressData || addOrganization.getAddress() == null) {
            return;
        }
        if (baseOrganization.getAddress() == null) {
            baseOrganization.setAddress((Address)new AddressImpl());
        }
        baseAddress = baseOrganization.getAddress();
        Address addAddress = addOrganization.getAddress();
        baseAddress.setVcardLocality(addAddress.getVcardLocality());
        baseAddress.setVcardPostalCode(addAddress.getVcardPostalCode());
        baseAddress.setVcardPostOfficeBox(addAddress.getVcardPostOfficeBox());
        baseAddress.setVcardStreetAddress(addAddress.getVcardStreetAddress());
        if (StringUtils.isNotEmpty((CharSequence)addAddress.getVcardCountryName())) {
            baseAddress.setVcardCountryName(addAddress.getVcardCountryName());
        }
    }
}

